/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.tools.record.filter;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.validation.Schema;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.datamodel.tools.DatamodelCopyUtils;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterLoadSaveException;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterNotFoundException;
import org.eclipse.smila.datamodel.tools.record.filter.messages.Annotation;
import org.eclipse.smila.datamodel.tools.record.filter.messages.Attribute;
import org.eclipse.smila.datamodel.tools.record.filter.messages.Filter;
import org.eclipse.smila.datamodel.tools.record.filter.messages.RecordFilters;
import org.eclipse.smila.utils.jaxb.JaxbUtils;
import org.eclipse.smila.utils.xml.SchemaUtils;
import org.xml.sax.SAXException;

public final class RecordFilterUtils {
    private static final String MASK_ANY = "*";
    private static final String BUNDLE_ID = "org.eclipse.smila.datamodel.tools";
    private static final String JAXB_PACKAGE = "org.eclipse.smila.datamodel.tools.record.filter.messages";
    private static final String SCHEMA_LOCATION = "schemas/RecordFilters.xsd";
    private static final Schema SCHEMA;

    static {
        try {
            SCHEMA = SchemaUtils.loadSchema((String)BUNDLE_ID, (String)SCHEMA_LOCATION);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private RecordFilterUtils() {
    }

    public static RecordFilters unmarshall(InputStream inputStream) throws RecordFilterLoadSaveException {
        try {
            return (RecordFilters)JaxbUtils.unmarshall((String)JAXB_PACKAGE, (ClassLoader)RecordFilters.class.getClassLoader(), (Schema)SCHEMA, (InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RecordFilterLoadSaveException(e);
        }
    }

    public static void marshall(RecordFilters recordFilters, OutputStream outputStream) throws RecordFilterLoadSaveException {
        try {
            JaxbUtils.marshall((Object)recordFilters, (String)JAXB_PACKAGE, (ClassLoader)RecordFilters.class.getClassLoader(), (Schema)SCHEMA, (OutputStream)outputStream);
        }
        catch (Throwable e) {
            throw new RecordFilterLoadSaveException(e);
        }
    }

    public static Filter findFilter(RecordFilters filters, String name) throws RecordFilterNotFoundException {
        if (name == null || "".equals(name)) {
            return filters.getFilter().get(0);
        }
        for (Filter filter : filters.getFilter()) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        throw new RecordFilterNotFoundException(name);
    }

    public static Record filter(Filter filter, Record record) {
        RecordFactory recordFactory = record.getFactory();
        Record newRecord = recordFactory.createRecord();
        newRecord.setId(record.getId());
        newRecord.setMetadata(RecordFilterUtils.filter(filter, record.getMetadata(), recordFactory));
        return newRecord;
    }

    public static MObject filter(Filter filter, MObject source, RecordFactory recordFactory) {
        String name;
        Iterator iterator;
        if (source == null) {
            throw new IllegalArgumentException("source MObject cannot be null!");
        }
        if (recordFactory == null) {
            throw new IllegalArgumentException("recordFactory cannot be null!");
        }
        MObject destination = recordFactory.createMetadataObject();
        destination.setSemanticType(source.getSemanticType());
        if (source.hasAttributes()) {
            iterator = source.getAttributeNames();
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                if (!RecordFilterUtils.isAttributePassedThroughFilter(filter, name)) continue;
                boolean doCopyAnnotations = RecordFilterUtils.isAttributeAnnotationsShouldBeCopied(filter, name);
                org.eclipse.smila.datamodel.record.Attribute attribute = DatamodelCopyUtils.cloneAttribute(source.getAttribute(name), recordFactory, doCopyAnnotations);
                destination.setAttribute(name, attribute);
            }
        }
        if (source.hasAnnotations()) {
            iterator = source.getAnnotationNames();
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                if (!RecordFilterUtils.isAnnotationPassedThroughFilter(filter, name)) continue;
                org.eclipse.smila.datamodel.record.Annotation annotation = DatamodelCopyUtils.cloneAnnotation(source.getAnnotation(name), recordFactory);
                destination.addAnnotation(name, annotation);
            }
        }
        return destination;
    }

    private static boolean isAttributePassedThroughFilter(Filter recordFilter, String name) {
        for (Attribute filterAttribute : recordFilter.getAttribute()) {
            if (!MASK_ANY.equals(filterAttribute.getName()) && !filterAttribute.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAttributeAnnotationsShouldBeCopied(Filter recordFilter, String name) {
        for (Attribute filterAttribute : recordFilter.getAttribute()) {
            if (!MASK_ANY.equals(filterAttribute.getName()) && !filterAttribute.getName().equals(name) || !filterAttribute.isKeepAnnotations()) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPassedThroughFilter(Filter recordFilter, String name) {
        for (Annotation filterAnnotation : recordFilter.getAnnotation()) {
            if (!MASK_ANY.equals(filterAnnotation.getName()) && !filterAnnotation.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

