/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ipc.json;

import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.eclipse.smila.ipc.IpcStreamWriter;

public class JsonStreamWriter
implements IpcStreamWriter {
    private static final JsonFactory FACTORY = new JsonFactory();
    private JsonGenerator _generator;

    JsonStreamWriter(OutputStream stream) throws IOException {
        try {
            this._generator = FACTORY.createJsonGenerator(stream, JsonEncoding.UTF8);
            this._generator.enable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            this._generator.useDefaultPrettyPrinter();
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this._generator != null) {
            this._generator.enable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            this._generator.close();
        }
    }

    @Override
    public void closeWithoutStream() throws IOException {
        if (this._generator != null) {
            this._generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            this._generator.close();
        }
    }

    @Override
    public void writeObjectEnd() throws IOException {
    }

    @Override
    public void writeObjectStart() throws IOException {
    }

    @Override
    public void writeMappingEnd() throws IOException {
        this._generator.writeEndObject();
    }

    @Override
    public void writeMappingStart() throws IOException {
        this._generator.writeStartObject();
    }

    @Override
    public void writeScalarBoolean(boolean b) throws IOException {
        this._generator.writeBoolean(b);
    }

    @Override
    public void writeScalarDouble(double d) throws IOException {
        this._generator.writeNumber(d);
    }

    @Override
    public void writeScalarInt(int i) throws IOException {
        this._generator.writeNumber(i);
    }

    @Override
    public void writeScalarLong(long i) throws IOException {
        this._generator.writeNumber(i);
    }

    @Override
    public void writeScalarString(String s) throws IOException {
        this._generator.writeString(s);
    }

    @Override
    public void writeSequenceEnd() throws IOException {
        this._generator.writeEndArray();
    }

    @Override
    public void writeSequenceStart() throws IOException {
        this._generator.writeStartArray();
    }

    @Override
    public void writeMappingKey(String s) throws IOException {
        this._generator.writeFieldName(s);
    }
}

