/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence.io;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;
import org.eclipse.smila.binarystorage.persistence.io.BssIOUtils;
import org.eclipse.smila.binarystorage.persistence.io.IOBinaryPersistence;

public class IOHierarchicalManager
extends IOBinaryPersistence {
    private static final String FORBIDDEN_CHARS = ";/\\:";
    private int _pathDepth = 2;
    private final byte _length = (byte)2;
    private static final String _separator = File.separator;

    public IOHierarchicalManager(BinaryStorageConfiguration binaryStorageConfig) throws BinaryStorageException {
        super(binaryStorageConfig);
        int pathDepthInt;
        Integer pathDepth = binaryStorageConfig.getPathDepth();
        if (pathDepth != null && (pathDepthInt = pathDepth.intValue()) > 0) {
            this._pathDepth = pathDepthInt;
        }
    }

    @Override
    public void storeBinary(String key, byte[] content) throws BinaryStorageException {
        super.storeBinary(this.calculateDirectoryPath(key), content);
    }

    @Override
    public void storeBinary(String key, InputStream stream) throws BinaryStorageException {
        super.storeBinary(this.calculateDirectoryPath(key), stream);
    }

    @Override
    public byte[] loadBinaryAsByteArray(String key) throws BinaryStorageException {
        return super.loadBinaryAsByteArray(this.calculateDirectoryPath(key));
    }

    @Override
    public InputStream loadBinaryAsInputStream(String key) throws BinaryStorageException {
        return super.loadBinaryAsInputStream(this.calculateDirectoryPath(key));
    }

    @Override
    public void deleteBinary(String key) throws BinaryStorageException {
        String path = this.calculateDirectoryPath(key);
        super.deleteBinary(path);
        File parentFolder = BssIOUtils.getFile(path).getParentFile();
        BssIOUtils.deleteEmptyParentFolders(parentFolder);
    }

    @Override
    public long fetchSize(String key) throws BinaryStorageException {
        return super.fetchSize(this.calculateDirectoryPath(key));
    }

    public String calculateDirectoryPath(String id) throws BinaryStorageException {
        if (StringUtils.containsAny((String)id, (String)FORBIDDEN_CHARS)) {
            throw new BinaryStorageException("id contains one of the forbidden chars ;/\\: : " + id);
        }
        try {
            StringBuffer internalPath = new StringBuffer();
            int i = 0;
            while (i < this._pathDepth && i * 2 + 2 < id.length()) {
                int offset = i * 2;
                internalPath.append(id.substring(offset, offset + 2));
                internalPath.append(_separator);
                ++i;
            }
            internalPath.append(id);
            return internalPath.toString();
        }
        catch (RuntimeException e) {
            throw new BinaryStorageException("unable to create path from id", (Throwable)e);
        }
    }
}

