/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.cmd.op;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smila.management.jmx.client.cmd.op.EqualsEvaluator;
import org.eclipse.smila.management.jmx.client.cmd.op.Evaluator;
import org.eclipse.smila.management.jmx.client.cmd.op.InEvaluator;
import org.eclipse.smila.management.jmx.client.config.BooleanOpType;
import org.eclipse.smila.management.jmx.client.config.EqualsOpType;
import org.eclipse.smila.management.jmx.client.config.InOpType;
import org.eclipse.smila.management.jmx.client.exceptions.EvaluationException;
import org.eclipse.smila.management.jmx.client.helpers.JmxConnection;

public final class EvalService {
    private static Map<Class, Evaluator> s_evaluators = new HashMap<Class, Evaluator>();

    static {
        s_evaluators.put(EqualsOpType.class, new EqualsEvaluator());
        s_evaluators.put(InOpType.class, new InEvaluator());
    }

    private EvalService() {
    }

    public static boolean eval(BooleanOpType config, JmxConnection connection, Object globalResult, String[] parameters, Object localResult) throws EvaluationException {
        Evaluator evaluator = s_evaluators.get(config.getClass());
        if (evaluator == null) {
            throw new RuntimeException(String.format("Evaluator [%s] is not found!", config.getClass()));
        }
        return evaluator.eval(config, connection, globalResult, parameters, localResult);
    }
}

