/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.messages.indexstructure.DAnalyzer;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexField;
import org.eclipse.smila.search.utils.indexstructure.DIndexStructure;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.set.DBoolean;
import org.eclipse.smila.search.utils.param.set.DDate;
import org.eclipse.smila.search.utils.param.set.DDateList;
import org.eclipse.smila.search.utils.param.set.DFloat;
import org.eclipse.smila.search.utils.param.set.DFloatList;
import org.eclipse.smila.search.utils.param.set.DInteger;
import org.eclipse.smila.search.utils.param.set.DIntegerList;
import org.eclipse.smila.search.utils.param.set.DParameter;
import org.eclipse.smila.search.utils.param.set.DParameterSet;
import org.eclipse.smila.search.utils.param.set.DString;
import org.eclipse.smila.search.utils.param.set.DStringList;

public abstract class AnalyzerFactory {
    private AnalyzerFactory() {
    }

    public static Analyzer getAnalyzer(DIndex dIndex) throws IndexException {
        return AnalyzerFactory.getAnalyzer(((org.eclipse.smila.search.lucene.messages.indexstructure.DIndexStructure)dIndex.getIndexStructure()).getAnalyzer(), (org.eclipse.smila.search.lucene.messages.indexstructure.DIndexStructure)dIndex.getIndexStructure());
    }

    public static Analyzer getAnalyzer(DIndexStructure dIndexStructure) throws IndexException {
        return AnalyzerFactory.getAnalyzer(((org.eclipse.smila.search.lucene.messages.indexstructure.DIndexStructure)dIndexStructure).getAnalyzer(), (org.eclipse.smila.search.lucene.messages.indexstructure.DIndexStructure)dIndexStructure);
    }

    public static Analyzer getAnalyzer(DAnalyzer dAnalyzer, org.eclipse.smila.search.lucene.messages.indexstructure.DIndexStructure dIndexStructure) throws IndexException {
        PerFieldAnalyzerWrapper wrapper;
        PerFieldAnalyzerWrapper analyzer = null;
        ArrayList<DIndexField> fieldsWithAnalyzer = new ArrayList<DIndexField>();
        Iterator<org.eclipse.smila.search.utils.indexstructure.DIndexField> it = dIndexStructure.getFields();
        while (it.hasNext()) {
            DIndexField field = (DIndexField)it.next();
            if (field.getAnalyzer() == null) continue;
            fieldsWithAnalyzer.add(field);
        }
        if (fieldsWithAnalyzer.size() > 0) {
            wrapper = new PerFieldAnalyzerWrapper(AnalyzerFactory.getAnalyzer(dAnalyzer));
            for (DIndexField field : fieldsWithAnalyzer) {
                wrapper.addAnalyzer(field.getName(), AnalyzerFactory.getAnalyzer(field.getAnalyzer()));
            }
        } else {
            return AnalyzerFactory.getAnalyzer(dAnalyzer);
        }
        analyzer = wrapper;
        return analyzer;
    }

    private static Analyzer getAnalyzer(DAnalyzer dAnalyzer) throws IndexException {
        List<List<Object>> values;
        Class<?> cAnalyzer;
        try {
            cAnalyzer = Class.forName(dAnalyzer.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IndexException("unable to load analyzer class. please ensure this class could be found on class path [" + dAnalyzer.getClassName() + "]");
        }
        try {
            values = AnalyzerFactory.getParameterSetValues(dAnalyzer.getParameterSet());
        }
        catch (ParameterException e) {
            throw new IndexException("unable to resolve analyzer parameter", (Throwable)e);
        }
        Constructor<?> analyzerConstructor = null;
        List<Object> constructorParameterClasses = values.get(0);
        try {
            analyzerConstructor = cAnalyzer.getConstructor(constructorParameterClasses.toArray(new Class[0]));
        }
        catch (Exception e) {
            throw new IndexException("unable to receive constructor for analyzer [" + dAnalyzer.getClassName() + "]", (Throwable)e);
        }
        List<Object> constructorParameterValues = values.get(1);
        Analyzer analyzer = null;
        try {
            analyzer = (Analyzer)analyzerConstructor.newInstance(constructorParameterValues.toArray());
        }
        catch (Exception e) {
            throw new IndexException("unable to create analyzer [" + dAnalyzer.getClassName() + "]", (Throwable)e);
        }
        return analyzer;
    }

    private static List<List<Object>> getParameterSetValues(DParameterSet parameterSet) throws ParameterException {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        ArrayList<Class<Object>> classes = new ArrayList<Class<Object>>();
        ArrayList<Object> objects = new ArrayList<Object>();
        values.add(classes);
        values.add(objects);
        if (parameterSet != null) {
            DParameter[] parameters;
            DParameter[] dParameterArray = parameters = parameterSet.getParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                DParameter parameter = dParameterArray[n2];
                if (parameter instanceof DBoolean) {
                    classes.add(Boolean.TYPE);
                    objects.add(((DBoolean)parameter).getValue());
                } else if (parameter instanceof DString) {
                    classes.add(String.class);
                    objects.add(((DString)parameter).getValue());
                } else if (parameter instanceof DInteger) {
                    classes.add(Integer.TYPE);
                    objects.add(((DInteger)parameter).getValue());
                } else if (parameter instanceof DFloat) {
                    classes.add(Float.TYPE);
                    objects.add(Float.valueOf(((DFloat)parameter).getValue()));
                } else if (parameter instanceof DDate) {
                    classes.add(Date.class);
                    objects.add(((DDate)parameter).getValue());
                } else if (parameter instanceof DStringList) {
                    classes.add(String[].class);
                    objects.add(((DStringList)parameter).getValues());
                } else if (parameter instanceof DIntegerList) {
                    classes.add(int[].class);
                    objects.add(((DIntegerList)parameter).getValues());
                } else if (parameter instanceof DFloatList) {
                    classes.add(float[].class);
                    objects.add(((DFloatList)parameter).getValues());
                } else if (parameter instanceof DDateList) {
                    classes.add(Date[].class);
                    objects.add(((DDateList)parameter).getValues());
                } else {
                    throw new ParameterException("Unknown parameter type [" + parameter.getClass() + "]");
                }
                ++n2;
            }
        }
        return values;
    }
}

