/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index;

import org.apache.lucene.analysis.Token;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.TokenGroup;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;

public class AnnotationFormatter
implements Formatter {
    private String _originalText;
    private AnySeq _highlightPositions;
    private final DataFactory _factory;

    public AnnotationFormatter(DataFactory factory) {
        this._factory = factory;
    }

    public String highlightTerm(String originalText, TokenGroup tokenGroup) {
        int index = 0;
        while (index < tokenGroup.getNumTokens()) {
            Token token = tokenGroup.getToken(index);
            float score = tokenGroup.getScore(index);
            int startOffset = token.startOffset();
            int endOffset = token.endOffset();
            if (score > 0.0f) {
                AnyMap highlightPos = this._factory.createAnyMap();
                highlightPos.put((Object)"start", (Object)this._factory.createLongValue(startOffset));
                highlightPos.put((Object)"end", (Object)this._factory.createLongValue(endOffset));
                highlightPos.put((Object)"quality", (Object)this._factory.createLongValue(AnnotationFormatter.mapScore(score)));
                this._highlightPositions.add((Object)highlightPos);
            }
            ++index;
        }
        return originalText;
    }

    public void reset(String originalText) {
        this._originalText = originalText;
        if (this._highlightPositions != null) {
            this._highlightPositions.clear();
        }
        this._highlightPositions = this._factory.createAnySeq();
    }

    public AnySeq getHighlightPositions() {
        return this._highlightPositions;
    }

    public String getOriginalText() {
        return this._originalText;
    }

    private static int mapScore(float score) {
        return Math.round(score * 250.0f);
    }
}

