/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index.access;

import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedCondition;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedOperation;

public abstract class SynchronizedAbstractExecutor<InitObject, ReturnedType> {
    private static final int INDEX_ACCESS_ATTEMPTS_NUMBER = 10;
    private static final int INDEX_ACCESS_BASE_PAUSE = 50;
    private static final int OPERATION_EXECUTE_ATTEMPTS_NUMBER = 10;
    private static final int OPERATION_EXECUTE_BASE_PAUSE = 50;
    private final Object _monitored;

    public SynchronizedAbstractExecutor(Object monitored) {
        this._monitored = monitored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnedType execute(ISynchronizedCondition<InitObject> condition, ISynchronizedOperation<InitObject, ReturnedType> operation) throws IndexException {
        int i = 0;
        Object initObject = null;
        while (initObject == null && i < 10) {
            this.sleep(i * 50);
            ++i;
            Object object = this._monitored;
            synchronized (object) {
                try {
                    initObject = condition.initialize();
                }
                catch (IndexException e) {
                    if (i == 10) {
                        throw e;
                    }
                    continue;
                }
                int j = 0;
                boolean isSuccessfully = false;
                while (!isSuccessfully && j < 10) {
                    this.sleep(j * 50);
                    boolean isLast = ++j == 10;
                    try {
                        ReturnedType result = operation.process(initObject);
                        isSuccessfully = true;
                        return result;
                    }
                    catch (IndexException e) {
                        if (!isLast) continue;
                        throw e;
                    }
                }
            }
        }
        throw new IndexException("Unable to initialize object");
    }

    private void sleep(long ms) {
        if (ms > 0L) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected abstract void close(InitObject var1) throws IndexException;

    public abstract ReturnedType execute(ISynchronizedOperation<InitObject, ReturnedType> var1) throws IndexException;
}

