/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DQueryExpressionCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.utils.advsearch.IQueryExpression;
import org.eclipse.smila.search.utils.advsearch.ITerm;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public class DQueryExpression
implements IQueryExpression {
    private String _indexName;
    private ITerm _term;
    private int _maxHits;
    private int _minSimilarity;
    private boolean _showHitDistribution;
    private Integer _startHits;

    public DQueryExpression(String indexName, int maxHits) {
        this.setIndexName(indexName);
        this.setMaxHits(maxHits);
    }

    public DQueryExpression() {
    }

    public Object clone() {
        DQueryExpression obj = null;
        try {
            obj = (DQueryExpression)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Cannot clone DQueryExpression", e);
        }
        if (this._term != null) {
            obj.setTerm((ITerm)((DTerm)this._term).clone());
        }
        if (this._startHits != null) {
            obj.setStartHits(new Integer(this._startHits));
        }
        return obj;
    }

    public int getMaxHits() {
        return this._maxHits;
    }

    public void setMaxHits(int maxHits) {
        this._maxHits = maxHits;
    }

    public String getIndexName() {
        return this._indexName;
    }

    public void setIndexName(String indexName) {
        this._indexName = indexName;
    }

    public void setShowHitDistribution(boolean showHitDistribution) {
        this._showHitDistribution = showHitDistribution;
    }

    public boolean getShowHitDistribution() {
        return this._showHitDistribution;
    }

    public ITerm getTerm() {
        return this._term;
    }

    public ITerm setTerm(ITerm term) {
        this._term = term;
        return term;
    }

    public int getMinSimilarity() {
        return this._minSimilarity;
    }

    public void setMinSimilarity(int minSimilarity) {
        this._minSimilarity = minSimilarity;
    }

    public String toString() {
        try {
            Element el = DQueryExpressionCodec.encode(this, XMLUtils.getDocument().createElement("Dummy"));
            el.getOwnerDocument().appendChild(el);
            String s = new String(XMLUtils.stream((Element)el, (boolean)false));
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public Integer getStartHits() {
        return this._startHits;
    }

    public void setStartHits(Integer startHits) {
        this._startHits = startHits;
    }
}

