/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.advsearch.DTermContent;
import org.eclipse.smila.search.lucene.messages.advsearch.DWMEANCodec;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public class DWMEAN
extends DTermContent
implements Cloneable {
    private String _operation;
    private ArrayList<DTerm> _terms = new ArrayList();
    private ArrayList<Float> _boosts = new ArrayList();
    private ArrayList<String> _constraints = new ArrayList();

    public DWMEAN() {
    }

    public DWMEAN(String operation, DTerm[] terms, float[] boosts, String[] constraints) {
        this.setOperation(operation);
        int i = 0;
        while (i < terms.length) {
            this.addTerm(terms[i], boosts[i], constraints[i]);
            ++i;
        }
    }

    @Override
    public Object clone() {
        DWMEAN obj = (DWMEAN)super.clone();
        obj._terms = new ArrayList();
        obj._boosts = new ArrayList();
        obj._constraints = new ArrayList();
        int i = 0;
        while (i < this._terms.size()) {
            obj.addTerm((DTerm)this._terms.get(i).clone(), this._boosts.get(i), this._constraints.get(i));
            ++i;
        }
        return obj;
    }

    public String getOperation() {
        return this._operation;
    }

    public void setOperation(String operation) {
        if (operation == null || operation.equals("")) {
            operation = "MEAN";
        }
        this._operation = operation;
    }

    public void addTerm(DTerm dTerm, Float boost, String constraint) {
        this._terms.add(dTerm);
        if (constraint == null || constraint.equals("")) {
            constraint = "optional";
        }
        this._constraints.add(constraint);
        if (boost.floatValue() < 0.0f) {
            this._boosts.add(new Float(0.0f));
        } else {
            this._boosts.add(boost);
        }
    }

    public void addTerm(DTerm dTerm, float boost, String constraint) {
        this.addTerm(dTerm, new Float(boost), constraint);
    }

    public void removeTerm(int pos) {
        this._terms.remove(pos);
        this._boosts.remove(pos);
        this._constraints.remove(pos);
    }

    public Iterator<DTerm> getTerms() {
        return this._terms.iterator();
    }

    public Iterator<Float> getBoosts() {
        return this._boosts.iterator();
    }

    public Iterator<String> getConstraints() {
        return this._constraints.iterator();
    }

    public float getBoostForTerm(DTerm term) {
        int index = this._terms.indexOf(term);
        if (index < 0) {
            return 0.0f;
        }
        return this._boosts.get(index).floatValue();
    }

    public String getConstraintForTerm(DTerm term) {
        int index = this._terms.indexOf(term);
        return this._constraints.get(index);
    }

    public DTerm getTerm(int pos) {
        return this._terms.get(pos);
    }

    public float getBoost(int pos) {
        return this._boosts.get(pos).floatValue();
    }

    public String getConstraint(int pos) {
        return this._constraints.get(pos);
    }

    public DTerm setTerm(int pos, DTerm term, long boost, String constraint) {
        return this.setTerm(pos, term, new Long(boost), constraint);
    }

    public DTerm setTerm(int pos, DTerm term, Float boost, String constraint) {
        if (boost.floatValue() < 0.0f) {
            this._boosts.set(pos, new Float(0.0f));
        } else {
            this._boosts.set(pos, boost);
        }
        if (constraint == null || constraint.equals("")) {
            constraint = "optional";
        }
        this._constraints.set(pos, constraint);
        return this._terms.set(pos, term);
    }

    public int getTermCount() {
        return this._terms.size();
    }

    @Override
    public String getType() {
        return "WMEAN";
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        try {
            Element el = DWMEANCodec.encode(this, XMLUtils.getDocument().createElement("T"));
            el.getOwnerDocument().appendChild(el);
            String s = new String(XMLUtils.stream((Element)el, (boolean)false));
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

