/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.tools.search.lucene;

import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.ITFParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DTextFieldParameterCodec {
    private static final String PARAMETER_NS = "http://www.anyfinder.de/Search/TextField";

    private DTextFieldParameterCodec() {
    }

    public static Element encode(DTextFieldParameter dTextFieldParameter, Element element) throws DSearchException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS(PARAMETER_NS, "Parameter");
        element.appendChild(el);
        if (dTextFieldParameter.getOperator() != null) {
            el.setAttribute("Operator", dTextFieldParameter.getOperator().toString());
        }
        if (dTextFieldParameter.getTolerance() != null) {
            el.setAttribute("Tolerance", dTextFieldParameter.getTolerance().toString());
        }
        return el;
    }

    public static Element encode(ITFParameter dTFP, Element element) throws DSearchException {
        if (dTFP instanceof DTextFieldParameter) {
            return DTextFieldParameterCodec.encode((DTextFieldParameter)dTFP, element);
        }
        throw new DSearchException("DTextFieldParameter type is invalid [" + dTFP.getClass().getName() + "]");
    }

    public static ITFParameter decode(Element element) throws DSearchException {
        DTextFieldParameter dTFP = new DTextFieldParameter();
        if (element.hasAttribute("Operator")) {
            dTFP.setOperator(DTextFieldParameter.DOperator.getInstance(element.getAttribute("Operator")));
        }
        if (element.hasAttribute("Tolerance")) {
            dTFP.setTolerance(DTextFieldParameter.DTolerance.getInstance(element.getAttribute("Tolerance")));
        }
        return dTFP;
    }
}

