/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

public class Statements {
    protected String messageTableName = "ACTIVEMQ_MSGS";
    protected String durableSubAcksTableName = "ACTIVEMQ_ACKS";
    protected String lockTableName = "ACTIVEMQ_LOCK";
    protected String binaryDataType = "BLOB";
    protected String containerNameDataType = "VARCHAR(250)";
    protected String msgIdDataType = "VARCHAR(250)";
    protected String sequenceDataType = "INTEGER";
    protected String longDataType = "BIGINT";
    protected String stringIdDataType = "VARCHAR(250)";
    protected boolean useExternalMessageReferences;
    private String tablePrefix = "";
    private String addMessageStatement;
    private String updateMessageStatement;
    private String removeMessageStatment;
    private String findMessageSequenceIdStatement;
    private String findMessageStatement;
    private String findAllMessagesStatement;
    private String findLastSequenceIdInMsgsStatement;
    private String findLastSequenceIdInAcksStatement;
    private String createDurableSubStatement;
    private String findDurableSubStatement;
    private String findAllDurableSubsStatement;
    private String updateLastAckOfDurableSubStatement;
    private String deleteSubscriptionStatement;
    private String findAllDurableSubMessagesStatement;
    private String findDurableSubMessagesStatement;
    private String findAllDestinationsStatement;
    private String removeAllMessagesStatement;
    private String removeAllSubscriptionsStatement;
    private String deleteOldMessagesStatement;
    private String[] createSchemaStatements;
    private String[] dropSchemaStatements;
    private String lockCreateStatement;
    private String lockUpdateStatement;
    private String nextDurableSubscriberMessageStatement;
    private String durableSubscriberMessageCountStatement;
    private String lastAckedDurableSubscriberMessageStatement;
    private String destinationMessageCountStatement;
    private String findNextMessagesStatement;
    private boolean useLockCreateWhereClause;

    public String[] getCreateSchemaStatements() {
        if (this.createSchemaStatements == null) {
            this.createSchemaStatements = new String[]{"CREATE TABLE " + this.getFullMessageTableName() + "(" + "ID " + this.sequenceDataType + " NOT NULL" + ", CONTAINER " + this.containerNameDataType + ", MSGID_PROD " + this.msgIdDataType + ", MSGID_SEQ " + this.sequenceDataType + ", EXPIRATION " + this.longDataType + ", MSG " + (this.useExternalMessageReferences ? this.stringIdDataType : this.binaryDataType) + ", PRIMARY KEY ( ID ) )", "CREATE INDEX " + this.getFullMessageTableName() + "_MIDX ON " + this.getFullMessageTableName() + " (MSGID_PROD,MSGID_SEQ)", "CREATE INDEX " + this.getFullMessageTableName() + "_CIDX ON " + this.getFullMessageTableName() + " (CONTAINER)", "CREATE INDEX " + this.getFullMessageTableName() + "_EIDX ON " + this.getFullMessageTableName() + " (EXPIRATION)", "CREATE TABLE " + this.getFullAckTableName() + "(" + "CONTAINER " + this.containerNameDataType + " NOT NULL" + ", SUB_DEST " + this.stringIdDataType + ", CLIENT_ID " + this.stringIdDataType + " NOT NULL" + ", SUB_NAME " + this.stringIdDataType + " NOT NULL" + ", SELECTOR " + this.stringIdDataType + ", LAST_ACKED_ID " + this.sequenceDataType + ", PRIMARY KEY ( CONTAINER, CLIENT_ID, SUB_NAME))", "CREATE TABLE " + this.getFullLockTableName() + "( ID " + this.longDataType + " NOT NULL, TIME " + this.longDataType + ", BROKER_NAME " + this.stringIdDataType + ", PRIMARY KEY (ID) )", "INSERT INTO " + this.getFullLockTableName() + "(ID) VALUES (1)"};
        }
        return this.createSchemaStatements;
    }

    public String[] getDropSchemaStatements() {
        if (this.dropSchemaStatements == null) {
            this.dropSchemaStatements = new String[]{"DROP TABLE " + this.getFullAckTableName() + "", "DROP TABLE " + this.getFullMessageTableName() + ""};
        }
        return this.dropSchemaStatements;
    }

    public String getAddMessageStatement() {
        if (this.addMessageStatement == null) {
            this.addMessageStatement = "INSERT INTO " + this.getFullMessageTableName() + "(ID, MSGID_PROD, MSGID_SEQ, CONTAINER, EXPIRATION, MSG) VALUES (?, ?, ?, ?, ?, ?)";
        }
        return this.addMessageStatement;
    }

    public String getUpdateMessageStatement() {
        if (this.updateMessageStatement == null) {
            this.updateMessageStatement = "UPDATE " + this.getFullMessageTableName() + " SET MSG=? WHERE ID=?";
        }
        return this.updateMessageStatement;
    }

    public String getRemoveMessageStatment() {
        if (this.removeMessageStatment == null) {
            this.removeMessageStatment = "DELETE FROM " + this.getFullMessageTableName() + " WHERE ID=?";
        }
        return this.removeMessageStatment;
    }

    public String getFindMessageSequenceIdStatement() {
        if (this.findMessageSequenceIdStatement == null) {
            this.findMessageSequenceIdStatement = "SELECT ID FROM " + this.getFullMessageTableName() + " WHERE MSGID_PROD=? AND MSGID_SEQ=?";
        }
        return this.findMessageSequenceIdStatement;
    }

    public String getFindMessageStatement() {
        if (this.findMessageStatement == null) {
            this.findMessageStatement = "SELECT MSG FROM " + this.getFullMessageTableName() + " WHERE ID=?";
        }
        return this.findMessageStatement;
    }

    public String getFindAllMessagesStatement() {
        if (this.findAllMessagesStatement == null) {
            this.findAllMessagesStatement = "SELECT ID, MSG FROM " + this.getFullMessageTableName() + " WHERE CONTAINER=? ORDER BY ID";
        }
        return this.findAllMessagesStatement;
    }

    public String getFindLastSequenceIdInMsgsStatement() {
        if (this.findLastSequenceIdInMsgsStatement == null) {
            this.findLastSequenceIdInMsgsStatement = "SELECT MAX(ID) FROM " + this.getFullMessageTableName();
        }
        return this.findLastSequenceIdInMsgsStatement;
    }

    public String getFindLastSequenceIdInAcksStatement() {
        if (this.findLastSequenceIdInAcksStatement == null) {
            this.findLastSequenceIdInAcksStatement = "SELECT MAX(LAST_ACKED_ID) FROM " + this.getFullAckTableName();
        }
        return this.findLastSequenceIdInAcksStatement;
    }

    public String getCreateDurableSubStatement() {
        if (this.createDurableSubStatement == null) {
            this.createDurableSubStatement = "INSERT INTO " + this.getFullAckTableName() + "(CONTAINER, CLIENT_ID, SUB_NAME, SELECTOR, LAST_ACKED_ID, SUB_DEST) " + "VALUES (?, ?, ?, ?, ?, ?)";
        }
        return this.createDurableSubStatement;
    }

    public String getFindDurableSubStatement() {
        if (this.findDurableSubStatement == null) {
            this.findDurableSubStatement = "SELECT SELECTOR, SUB_DEST FROM " + this.getFullAckTableName() + " WHERE CONTAINER=? AND CLIENT_ID=? AND SUB_NAME=?";
        }
        return this.findDurableSubStatement;
    }

    public String getFindAllDurableSubsStatement() {
        if (this.findAllDurableSubsStatement == null) {
            this.findAllDurableSubsStatement = "SELECT SELECTOR, SUB_NAME, CLIENT_ID, SUB_DEST FROM " + this.getFullAckTableName() + " WHERE CONTAINER=?";
        }
        return this.findAllDurableSubsStatement;
    }

    public String getUpdateLastAckOfDurableSubStatement() {
        if (this.updateLastAckOfDurableSubStatement == null) {
            this.updateLastAckOfDurableSubStatement = "UPDATE " + this.getFullAckTableName() + " SET LAST_ACKED_ID=?" + " WHERE CONTAINER=? AND CLIENT_ID=? AND SUB_NAME=?";
        }
        return this.updateLastAckOfDurableSubStatement;
    }

    public String getDeleteSubscriptionStatement() {
        if (this.deleteSubscriptionStatement == null) {
            this.deleteSubscriptionStatement = "DELETE FROM " + this.getFullAckTableName() + " WHERE CONTAINER=? AND CLIENT_ID=? AND SUB_NAME=?";
        }
        return this.deleteSubscriptionStatement;
    }

    public String getFindAllDurableSubMessagesStatement() {
        if (this.findAllDurableSubMessagesStatement == null) {
            this.findAllDurableSubMessagesStatement = "SELECT M.ID, M.MSG FROM " + this.getFullMessageTableName() + " M, " + this.getFullAckTableName() + " D " + " WHERE D.CONTAINER=? AND D.CLIENT_ID=? AND D.SUB_NAME=?" + " AND M.CONTAINER=D.CONTAINER AND M.ID > D.LAST_ACKED_ID" + " ORDER BY M.ID";
        }
        return this.findAllDurableSubMessagesStatement;
    }

    public String getFindDurableSubMessagesStatement() {
        if (this.findDurableSubMessagesStatement == null) {
            this.findDurableSubMessagesStatement = "SELECT M.ID, M.MSG FROM " + this.getFullMessageTableName() + " M, " + this.getFullAckTableName() + " D " + " WHERE D.CONTAINER=? AND D.CLIENT_ID=? AND D.SUB_NAME=?" + " AND M.CONTAINER=D.CONTAINER AND M.ID > ?" + " ORDER BY M.ID";
        }
        return this.findDurableSubMessagesStatement;
    }

    public String findAllDurableSubMessagesStatement() {
        if (this.findAllDurableSubMessagesStatement == null) {
            this.findAllDurableSubMessagesStatement = "SELECT M.ID, M.MSG FROM " + this.getFullMessageTableName() + " M, " + this.getFullAckTableName() + " D " + " WHERE D.CONTAINER=? AND D.CLIENT_ID=? AND D.SUB_NAME=?" + " AND M.CONTAINER=D.CONTAINER AND M.ID > D.LAST_ACKED_ID" + " ORDER BY M.ID";
        }
        return this.findAllDurableSubMessagesStatement;
    }

    public String getNextDurableSubscriberMessageStatement() {
        if (this.nextDurableSubscriberMessageStatement == null) {
            this.nextDurableSubscriberMessageStatement = "SELECT M.ID, M.MSG FROM " + this.getFullMessageTableName() + " M, " + this.getFullAckTableName() + " D " + " WHERE D.CONTAINER=? AND D.CLIENT_ID=? AND D.SUB_NAME=?" + " AND M.CONTAINER=D.CONTAINER AND M.ID > ?" + " ORDER BY M.ID ";
        }
        return this.nextDurableSubscriberMessageStatement;
    }

    public String getDurableSubscriberMessageCountStatement() {
        if (this.durableSubscriberMessageCountStatement == null) {
            this.durableSubscriberMessageCountStatement = "SELECT COUNT(*) FROM " + this.getFullMessageTableName() + " M, " + this.getFullAckTableName() + " D " + " WHERE D.CONTAINER=? AND D.CLIENT_ID=? AND D.SUB_NAME=?" + " AND M.CONTAINER=D.CONTAINER AND M.ID > D.LAST_ACKED_ID";
        }
        return this.durableSubscriberMessageCountStatement;
    }

    public String getFindAllDestinationsStatement() {
        if (this.findAllDestinationsStatement == null) {
            this.findAllDestinationsStatement = "SELECT DISTINCT CONTAINER FROM " + this.getFullMessageTableName();
        }
        return this.findAllDestinationsStatement;
    }

    public String getRemoveAllMessagesStatement() {
        if (this.removeAllMessagesStatement == null) {
            this.removeAllMessagesStatement = "DELETE FROM " + this.getFullMessageTableName() + " WHERE CONTAINER=?";
        }
        return this.removeAllMessagesStatement;
    }

    public String getRemoveAllSubscriptionsStatement() {
        if (this.removeAllSubscriptionsStatement == null) {
            this.removeAllSubscriptionsStatement = "DELETE FROM " + this.getFullAckTableName() + " WHERE CONTAINER=?";
        }
        return this.removeAllSubscriptionsStatement;
    }

    public String getDeleteOldMessagesStatement() {
        if (this.deleteOldMessagesStatement == null) {
            this.deleteOldMessagesStatement = "DELETE FROM " + this.getFullMessageTableName() + " WHERE ( EXPIRATION<>0 AND EXPIRATION<?) OR ID <= " + "( SELECT min(" + this.getFullAckTableName() + ".LAST_ACKED_ID) " + "FROM " + this.getFullAckTableName() + " WHERE " + this.getFullAckTableName() + ".CONTAINER=" + this.getFullMessageTableName() + ".CONTAINER)";
        }
        return this.deleteOldMessagesStatement;
    }

    public String getLockCreateStatement() {
        if (this.lockCreateStatement == null) {
            this.lockCreateStatement = "SELECT * FROM " + this.getFullLockTableName();
            if (this.useLockCreateWhereClause) {
                this.lockCreateStatement = this.lockCreateStatement + " WHERE ID = 1";
            }
            this.lockCreateStatement = this.lockCreateStatement + " FOR UPDATE";
        }
        return this.lockCreateStatement;
    }

    public String getLockUpdateStatement() {
        if (this.lockUpdateStatement == null) {
            this.lockUpdateStatement = "UPDATE " + this.getFullLockTableName() + " SET TIME = ? WHERE ID = 1";
        }
        return this.lockUpdateStatement;
    }

    public String getDestinationMessageCountStatement() {
        if (this.destinationMessageCountStatement == null) {
            this.destinationMessageCountStatement = "SELECT COUNT(*) FROM " + this.getFullMessageTableName() + " WHERE CONTAINER=?";
        }
        return this.destinationMessageCountStatement;
    }

    public String getFindNextMessagesStatement() {
        if (this.findNextMessagesStatement == null) {
            this.findNextMessagesStatement = "SELECT ID, MSG FROM " + this.getFullMessageTableName() + " WHERE CONTAINER=? AND ID > ? ORDER BY ID";
        }
        return this.findNextMessagesStatement;
    }

    public String getLastAckedDurableSubscriberMessageStatement() {
        if (this.lastAckedDurableSubscriberMessageStatement == null) {
            this.lastAckedDurableSubscriberMessageStatement = "SELECT MAX(LAST_ACKED_ID) FROM " + this.getFullAckTableName() + " WHERE CONTAINER=? AND CLIENT_ID=? AND SUB_NAME=?";
        }
        return this.lastAckedDurableSubscriberMessageStatement;
    }

    public String getFullMessageTableName() {
        return this.getTablePrefix() + this.getMessageTableName();
    }

    public String getFullAckTableName() {
        return this.getTablePrefix() + this.getDurableSubAcksTableName();
    }

    public String getFullLockTableName() {
        return this.getTablePrefix() + this.getLockTableName();
    }

    public String getContainerNameDataType() {
        return this.containerNameDataType;
    }

    public void setContainerNameDataType(String containerNameDataType) {
        this.containerNameDataType = containerNameDataType;
    }

    public String getBinaryDataType() {
        return this.binaryDataType;
    }

    public void setBinaryDataType(String messageDataType) {
        this.binaryDataType = messageDataType;
    }

    public String getMessageTableName() {
        return this.messageTableName;
    }

    public void setMessageTableName(String messageTableName) {
        this.messageTableName = messageTableName;
    }

    public String getMsgIdDataType() {
        return this.msgIdDataType;
    }

    public void setMsgIdDataType(String msgIdDataType) {
        this.msgIdDataType = msgIdDataType;
    }

    public String getSequenceDataType() {
        return this.sequenceDataType;
    }

    public void setSequenceDataType(String sequenceDataType) {
        this.sequenceDataType = sequenceDataType;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getDurableSubAcksTableName() {
        return this.durableSubAcksTableName;
    }

    public void setDurableSubAcksTableName(String durableSubAcksTableName) {
        this.durableSubAcksTableName = durableSubAcksTableName;
    }

    public String getLockTableName() {
        return this.lockTableName;
    }

    public void setLockTableName(String lockTableName) {
        this.lockTableName = lockTableName;
    }

    public String getLongDataType() {
        return this.longDataType;
    }

    public void setLongDataType(String longDataType) {
        this.longDataType = longDataType;
    }

    public String getStringIdDataType() {
        return this.stringIdDataType;
    }

    public void setStringIdDataType(String stringIdDataType) {
        this.stringIdDataType = stringIdDataType;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setAddMessageStatement(String addMessageStatment) {
        this.addMessageStatement = addMessageStatment;
    }

    public void setCreateDurableSubStatement(String createDurableSubStatment) {
        this.createDurableSubStatement = createDurableSubStatment;
    }

    public void setCreateSchemaStatements(String[] createSchemaStatments) {
        this.createSchemaStatements = createSchemaStatments;
    }

    public void setDeleteOldMessagesStatement(String deleteOldMessagesStatment) {
        this.deleteOldMessagesStatement = deleteOldMessagesStatment;
    }

    public void setDeleteSubscriptionStatement(String deleteSubscriptionStatment) {
        this.deleteSubscriptionStatement = deleteSubscriptionStatment;
    }

    public void setDropSchemaStatements(String[] dropSchemaStatments) {
        this.dropSchemaStatements = dropSchemaStatments;
    }

    public void setFindAllDestinationsStatement(String findAllDestinationsStatment) {
        this.findAllDestinationsStatement = findAllDestinationsStatment;
    }

    public void setFindAllDurableSubMessagesStatement(String findAllDurableSubMessagesStatment) {
        this.findAllDurableSubMessagesStatement = findAllDurableSubMessagesStatment;
    }

    public void setFindAllDurableSubsStatement(String findAllDurableSubsStatment) {
        this.findAllDurableSubsStatement = findAllDurableSubsStatment;
    }

    public void setFindAllMessagesStatement(String findAllMessagesStatment) {
        this.findAllMessagesStatement = findAllMessagesStatment;
    }

    public void setFindDurableSubStatement(String findDurableSubStatment) {
        this.findDurableSubStatement = findDurableSubStatment;
    }

    public void setFindLastSequenceIdInAcksStatement(String findLastSequenceIdInAcks) {
        this.findLastSequenceIdInAcksStatement = findLastSequenceIdInAcks;
    }

    public void setFindLastSequenceIdInMsgsStatement(String findLastSequenceIdInMsgs) {
        this.findLastSequenceIdInMsgsStatement = findLastSequenceIdInMsgs;
    }

    public void setFindMessageSequenceIdStatement(String findMessageSequenceIdStatment) {
        this.findMessageSequenceIdStatement = findMessageSequenceIdStatment;
    }

    public void setFindMessageStatement(String findMessageStatment) {
        this.findMessageStatement = findMessageStatment;
    }

    public void setRemoveAllMessagesStatement(String removeAllMessagesStatment) {
        this.removeAllMessagesStatement = removeAllMessagesStatment;
    }

    public void setRemoveAllSubscriptionsStatement(String removeAllSubscriptionsStatment) {
        this.removeAllSubscriptionsStatement = removeAllSubscriptionsStatment;
    }

    public void setRemoveMessageStatment(String removeMessageStatment) {
        this.removeMessageStatment = removeMessageStatment;
    }

    public void setUpdateLastAckOfDurableSubStatement(String updateLastAckOfDurableSub) {
        this.updateLastAckOfDurableSubStatement = updateLastAckOfDurableSub;
    }

    public void setUpdateMessageStatement(String updateMessageStatment) {
        this.updateMessageStatement = updateMessageStatment;
    }

    public boolean isUseLockCreateWhereClause() {
        return this.useLockCreateWhereClause;
    }

    public void setUseLockCreateWhereClause(boolean useLockCreateWhereClause) {
        this.useLockCreateWhereClause = useLockCreateWhereClause;
    }

    public void setLockCreateStatement(String lockCreateStatement) {
        this.lockCreateStatement = lockCreateStatement;
    }

    public void setLockUpdateStatement(String lockUpdateStatement) {
        this.lockUpdateStatement = lockUpdateStatement;
    }

    public void setFindDurableSubMessagesStatement(String findDurableSubMessagesStatement) {
        this.findDurableSubMessagesStatement = findDurableSubMessagesStatement;
    }

    public void setNextDurableSubscriberMessageStatement(String nextDurableSubscriberMessageStatement) {
        this.nextDurableSubscriberMessageStatement = nextDurableSubscriberMessageStatement;
    }

    public void setDurableSubscriberMessageCountStatement(String durableSubscriberMessageCountStatement) {
        this.durableSubscriberMessageCountStatement = durableSubscriberMessageCountStatement;
    }

    public void setFindNextMessagesStatement(String findNextMessagesStatement) {
        this.findNextMessagesStatement = findNextMessagesStatement;
    }

    public void setDestinationMessageCountStatement(String destinationMessageCountStatement) {
        this.destinationMessageCountStatement = destinationMessageCountStatement;
    }

    public void setLastAckedDurableSubscriberMessageStatement(String lastAckedDurableSubscriberMessageStatement) {
        this.lastAckedDurableSubscriberMessageStatement = lastAckedDurableSubscriberMessageStatement;
    }
}

