/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.ql.jcc;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ode.ql.jcc.ASTAnd;
import org.apache.ode.ql.jcc.ASTEqual;
import org.apache.ode.ql.jcc.ASTField;
import org.apache.ode.ql.jcc.ASTGE;
import org.apache.ode.ql.jcc.ASTGreater;
import org.apache.ode.ql.jcc.ASTIn;
import org.apache.ode.ql.jcc.ASTInValues;
import org.apache.ode.ql.jcc.ASTLE;
import org.apache.ode.ql.jcc.ASTLess;
import org.apache.ode.ql.jcc.ASTLike;
import org.apache.ode.ql.jcc.ASTLimit;
import org.apache.ode.ql.jcc.ASTOr;
import org.apache.ode.ql.jcc.ASTOrderBy;
import org.apache.ode.ql.jcc.ASTOrderByField;
import org.apache.ode.ql.jcc.ASTOrderType;
import org.apache.ode.ql.jcc.ASTProperty;
import org.apache.ode.ql.jcc.ASTStart;
import org.apache.ode.ql.jcc.ASTValue;
import org.apache.ode.ql.jcc.Node;
import org.apache.ode.ql.jcc.ParseException;
import org.apache.ode.ql.jcc.Parser;
import org.apache.ode.ql.tree.Builder;
import org.apache.ode.ql.tree.nodes.Conjunction;
import org.apache.ode.ql.tree.nodes.Disjunction;
import org.apache.ode.ql.tree.nodes.Equality;
import org.apache.ode.ql.tree.nodes.Field;
import org.apache.ode.ql.tree.nodes.GE;
import org.apache.ode.ql.tree.nodes.Greater;
import org.apache.ode.ql.tree.nodes.Identifier;
import org.apache.ode.ql.tree.nodes.In;
import org.apache.ode.ql.tree.nodes.LE;
import org.apache.ode.ql.tree.nodes.Less;
import org.apache.ode.ql.tree.nodes.Like;
import org.apache.ode.ql.tree.nodes.Limit;
import org.apache.ode.ql.tree.nodes.LogicNode;
import org.apache.ode.ql.tree.nodes.OrderBy;
import org.apache.ode.ql.tree.nodes.OrderByElement;
import org.apache.ode.ql.tree.nodes.OrderByType;
import org.apache.ode.ql.tree.nodes.Property;
import org.apache.ode.ql.tree.nodes.Query;
import org.apache.ode.ql.tree.nodes.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBuilder
extends Builder<String> {
    @Override
    public org.apache.ode.ql.tree.nodes.Node build(String string) {
        try {
            ASTStart aSTStart = new Parser(string).start();
            return this.build(aSTStart);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage(), parseException);
        }
    }

    @Override
    private org.apache.ode.ql.tree.nodes.Node build(Node node) {
        if (node instanceof ASTAnd) {
            return this.createConjunction(node);
        }
        if (node instanceof ASTOr) {
            return this.createDisjunction(node);
        }
        if (node instanceof ASTLess) {
            return this.createLess(node);
        }
        if (node instanceof ASTGreater) {
            return this.createGreater(node);
        }
        if (node instanceof ASTLE) {
            return this.createLE(node);
        }
        if (node instanceof ASTIn) {
            return this.createIn(node);
        }
        if (node instanceof ASTGE) {
            return this.createGE(node);
        }
        if (node instanceof ASTEqual) {
            return this.createEquality(node);
        }
        if (node instanceof ASTLike) {
            return this.createLike(node);
        }
        if (node instanceof ASTStart) {
            return this.createSelection((ASTStart)node);
        }
        throw new IllegalArgumentException("Unsupported node type " + node.getClass());
    }

    private Query createSelection(ASTStart aSTStart) {
        ArrayList<Object> arrayList = new ArrayList<Object>(aSTStart.jjtGetNumChildren());
        OrderBy orderBy = null;
        Limit limit = null;
        for (int i = 0; i < aSTStart.jjtGetNumChildren(); ++i) {
            Node node = aSTStart.jjtGetChild(i);
            if (node instanceof ASTOrderBy) {
                orderBy = this.createOrderBy(node);
                continue;
            }
            if (node instanceof ASTLimit) {
                limit = this.createLimit(node);
                continue;
            }
            org.apache.ode.ql.tree.nodes.Node node2 = this.build(node);
            arrayList.add(node2);
        }
        return new Query(arrayList, orderBy, limit);
    }

    private OrderBy createOrderBy(Node node) {
        ArrayList<OrderByElement> arrayList = new ArrayList<OrderByElement>(node.jjtGetNumChildren());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            arrayList.add(this.createOrderByElement((ASTOrderByField)node.jjtGetChild(i)));
        }
        return new OrderBy(arrayList);
    }

    private OrderByElement createOrderByElement(ASTOrderByField aSTOrderByField) {
        OrderByType orderByType;
        int n = aSTOrderByField.jjtGetNumChildren();
        if (n == 1) {
            orderByType = OrderByType.ASC;
        }
        if (n != 2) {
            throw new IllegalArgumentException();
        }
        Object object = (ASTOrderType)this.extractChildNode(aSTOrderByField, 1);
        orderByType = OrderByType.valueOf(((ASTOrderType)object).getValue().toUpperCase());
        object = this.createIdentifier(aSTOrderByField, 0);
        return new OrderByElement<Object>(object, orderByType);
    }

    private Conjunction createConjunction(Node node) {
        Collection<LogicNode> collection = this.extractLogicNodes(node);
        return new Conjunction(collection);
    }

    private Disjunction createDisjunction(Node node) {
        Collection<LogicNode> collection = this.extractLogicNodes(node);
        return new Disjunction(collection);
    }

    private LE createLE(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new LE(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private In createIn(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        Node node2 = this.extractChildNode(node, 1, ASTInValues.class);
        ArrayList<Value> arrayList = new ArrayList<Value>(node2.jjtGetNumChildren());
        for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
            arrayList.add(this.createValue(node2, i));
        }
        return new In(this.createIdentifier(node, 0), arrayList);
    }

    private GE createGE(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new GE(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Less createLess(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new Less(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Greater createGreater(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new Greater(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Equality createEquality(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new Equality(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Like createLike(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new Like(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Value createValue(Node node, int n) {
        return new Value<String>(this.extractValue((Node)node, (int)n).value);
    }

    private Limit createLimit(Node node) {
        return new Limit(((ASTLimit)node).getNumber());
    }

    private Identifier createIdentifier(Node node, int n) {
        Node node2 = this.extractChildNode(node, n);
        if (node2 instanceof ASTField) {
            return new Field(((ASTField)node2).name);
        }
        if (node2 instanceof ASTProperty) {
            return new Property(((ASTProperty)node2).getName());
        }
        throw new IllegalArgumentException("");
    }

    private ASTValue extractValue(Node node, int n) {
        return (ASTValue)this.extractChildNode(node, n, ASTValue.class);
    }

    private Node extractChildNode(Node node, int n, Class clazz) {
        Node node2 = this.extractChildNode(node, n);
        if (!clazz.isAssignableFrom(node2.getClass())) {
            throw new IllegalArgumentException("");
        }
        return node2;
    }

    private Node extractChildNode(Node node, int n) {
        if (node.jjtGetNumChildren() <= n) {
            throw new IllegalArgumentException("");
        }
        return node.jjtGetChild(n);
    }

    private Collection<LogicNode> extractLogicNodes(Node node) {
        ArrayList<LogicNode> arrayList = new ArrayList<LogicNode>(node.jjtGetNumChildren());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            arrayList.add((LogicNode)this.build(node.jjtGetChild(i)));
        }
        return arrayList;
    }

    private static void checkChildsNumber(Node node, int n) {
        int n2 = node.jjtGetNumChildren();
        if (n2 != n) {
            throw new IllegalArgumentException("Expected childs cound(" + n2 + ") differes from expected " + n);
        }
    }
}

