/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.highlighting;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DHighlightingTransformer;
import org.eclipse.smila.search.highlighting.HighlightingService;
import org.eclipse.smila.utils.service.ServiceUtils;

public class HighlightingPipelet
implements Pipelet {
    private final Log _log = LogFactory.getLog(HighlightingPipelet.class);
    private HighlightingService _service;
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] message) throws ProcessingException {
        block5: {
            if (message.length > 0) {
                try {
                    QueryParameterAccessor parameters;
                    HighlightingService service;
                    Map<String, DHighlightingTransformer> highlightConfigs;
                    AnySeq records = blackboard.getMetadata(message[0]).getSeq("records");
                    if (records != null && !records.isEmpty() && !(highlightConfigs = (service = this.getHighlightingService()).getTransformerConfigs(parameters = new QueryParameterAccessor(blackboard, this._configuration, message[0]))).isEmpty()) {
                        for (Any resultRecord : records) {
                            if (!resultRecord.isMap()) continue;
                            service.highlight((AnyMap)resultRecord, highlightConfigs);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!this._log.isErrorEnabled()) break block5;
                    this._log.error((Object)("error processing message " + message[0]), (Throwable)ex);
                }
            }
        }
        return message;
    }

    private synchronized HighlightingService getHighlightingService() throws InterruptedException {
        if (this._service == null) {
            this._service = (HighlightingService)ServiceUtils.getService(HighlightingService.class);
        }
        return this._service;
    }
}

