/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public class ErrorHandlerBuilderRef
extends ErrorHandlerBuilderSupport {
    private final String ref;
    private ErrorHandlerBuilder handler;

    public ErrorHandlerBuilderRef(String ref) {
        this.ref = ref;
    }

    public ErrorHandlerBuilder copy() {
        return new ErrorHandlerBuilderRef(this.ref);
    }

    public void addErrorHandlers(ExceptionType exception) {
        if (this.handler != null) {
            this.handler.addErrorHandlers(exception);
        }
        super.addErrorHandlers(exception);
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        if (this.handler == null) {
            this.handler = routeContext.lookup(this.ref, ErrorHandlerBuilder.class);
            ObjectHelper.notNull(this.handler, "error handler '" + this.ref + "'");
            List<ExceptionType> list = this.getExceptions();
            for (ExceptionType exceptionType : list) {
                this.handler.addErrorHandlers(exceptionType);
            }
        }
        return this.handler.createErrorHandler(routeContext, processor);
    }
}

