/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(FileProducer.class);
    private FileEndpoint endpoint;

    public FileProducer(FileEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public FileEndpoint getEndpoint() {
        return (FileEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        FileExchange fileExchange = (FileExchange)this.endpoint.createExchange(exchange);
        this.process(fileExchange);
        ExchangeHelper.copyResults(exchange, fileExchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(FileExchange exchange) throws Exception {
        InputStream in = ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
        File file = this.createFileName(exchange.getIn());
        this.buildDirectory(file);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to write to: " + file + " from exchange: " + exchange));
        }
        FileChannel fc = null;
        try {
            int count;
            if (this.getEndpoint().isAppend()) {
                fc = new RandomAccessFile(file, "rw").getChannel();
                fc.position(fc.size());
            } else {
                fc = new FileOutputStream(file).getChannel();
            }
            int size = this.getEndpoint().getBufferSize();
            byte[] buffer = new byte[size];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            while ((count = in.read(buffer)) > 0) {
                if (count < size) {
                    byteBuffer = ByteBuffer.wrap(buffer, 0, count);
                    fc.write(byteBuffer);
                    break;
                }
                fc.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            ObjectHelper.close(in, file.getName(), LOG);
            ObjectHelper.close(fc, file.getName(), LOG);
        }
    }

    protected File createFileName(Message message) {
        File answer;
        File endpointFile;
        String name = null;
        if (!this.endpoint.isIgnoreFileNameHeader()) {
            name = message.getHeader("org.apache.camel.file.name", String.class);
        }
        if ((endpointFile = this.endpoint.getFile()).isDirectory()) {
            if (name != null) {
                answer = new File(endpointFile, name);
                if (answer.isDirectory()) {
                    answer = new File(answer, this.endpoint.getGeneratedFileName(message));
                }
            } else {
                answer = new File(endpointFile, this.endpoint.getGeneratedFileName(message));
            }
        } else {
            answer = name == null ? endpointFile : new File(endpointFile, name);
        }
        message.setHeader("org.apache.camel.file.name.produced", answer.getAbsolutePath());
        return answer;
    }

    private void buildDirectory(File file) {
        String dirName = file.getAbsolutePath();
        int index = dirName.lastIndexOf(File.separatorChar);
        if (index > 0) {
            dirName = dirName.substring(0, index);
            File dir = new File(dirName);
            dir.mkdirs();
        }
    }
}

