/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.processor.interceptor.StreamCachingInterceptor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="multicast")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MulticastType
extends OutputType<ProcessorType> {
    @XmlAttribute(required=false)
    private Boolean parallelProcessing;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ThreadPoolExecutor threadPoolExecutor;

    public String toString() {
        return "Multicast[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "multicast";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createOutputsProcessor(routeContext);
    }

    @Override
    protected Processor createCompositeProcessor(List<Processor> list) {
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = new UseLatestAggregationStrategy();
        }
        return new MulticastProcessor(list, this.aggregationStrategy, this.isParallelProcessing(), this.threadPoolExecutor);
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public MulticastType setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
        return this;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing != null ? this.parallelProcessing : false;
    }

    public MulticastType setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
        return this;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public MulticastType setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this.threadPoolExecutor = executor;
        return this;
    }

    @Override
    protected Processor wrapProcessorInInterceptors(RouteContext routeContext, Processor target) throws Exception {
        return new StreamCachingInterceptor(target);
    }
}

