/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Route;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.model.FromType;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.interceptor.StreamCachingInterceptor;
import org.apache.camel.util.CamelContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="route")
@XmlType(propOrder={"inputs", "outputs"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class RouteType
extends ProcessorType<ProcessorType>
implements CamelContextAware {
    private static final transient Log LOG = LogFactory.getLog(RouteType.class);
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    private List<FromType> inputs = new ArrayList<FromType>();
    private List<ProcessorType<?>> outputs = new ArrayList();
    private String group;
    private CamelContext camelContext;
    private Boolean streamCaching;

    public RouteType() {
    }

    public RouteType(String uri) {
        this.from(uri);
    }

    public RouteType(Endpoint endpoint) {
        this.from(endpoint);
    }

    public String toString() {
        return "Route[ " + this.inputs + " -> " + this.outputs + "]";
    }

    public void addRoutes(CamelContext context, Collection<Route> routes) throws Exception {
        DefaultCamelContext defaultCamelContext;
        ErrorHandlerBuilder handler;
        this.setCamelContext(context);
        if (context instanceof DefaultCamelContext && (handler = (defaultCamelContext = (DefaultCamelContext)context).getErrorHandlerBuilder()) != null) {
            this.setErrorHandlerBuilderIfNull(handler);
        }
        for (FromType fromType : this.inputs) {
            this.addRoutes(routes, fromType);
        }
    }

    public Endpoint resolveEndpoint(String uri) throws NoSuchEndpointException {
        CamelContext context = this.getCamelContext();
        if (context == null) {
            throw new IllegalArgumentException("No CamelContext has been injected!");
        }
        return CamelContextHelper.getMandatoryEndpoint(context, uri);
    }

    public RouteType from(String uri) {
        this.getInputs().add(new FromType(uri));
        return this;
    }

    public RouteType from(Endpoint endpoint) {
        this.getInputs().add(new FromType(endpoint));
        return this;
    }

    public RouteType group(String name) {
        this.setGroup(name);
        return this;
    }

    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    @XmlTransient
    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }

    public List<FromType> getInputs() {
        return this.inputs;
    }

    @XmlElementRef
    public void setInputs(List<FromType> inputs) {
        this.inputs = inputs;
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return this.outputs;
    }

    @XmlElementRef
    public void setOutputs(List<ProcessorType<?>> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorType<?> output : outputs) {
                this.configureChild(output);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    @XmlTransient
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getGroup() {
        return this.group;
    }

    @XmlAttribute
    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean getStreamCaching() {
        return this.streamCaching;
    }

    @XmlAttribute(required=false)
    public void setStreamCaching(Boolean streamCaching) {
        this.streamCaching = streamCaching;
        if (streamCaching != null && streamCaching.booleanValue()) {
            this.streamCaching();
        } else {
            this.noStreamCaching();
        }
    }

    protected void addRoutes(Collection<Route> routes, FromType fromType) throws Exception {
        DefaultRouteContext routeContext = new DefaultRouteContext(this, fromType, routes);
        routeContext.getEndpoint();
        if (this.camelContext != null) {
            this.camelContext.getLifecycleStrategy().onRouteContextCreate(routeContext);
        }
        ArrayList list = new ArrayList(this.outputs);
        for (ProcessorType processorType : list) {
            processorType.addRoutes(routeContext, routes);
        }
        routeContext.commit();
    }

    @Override
    protected void configureChild(ProcessorType output) {
        super.configureChild(output);
        if (this.isInheritErrorHandler()) {
            output.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
        }
        List<InterceptorType> interceptors = this.getInterceptors();
        for (InterceptorType interceptor : interceptors) {
            output.addInterceptor(interceptor);
        }
    }

    public RouteType noStreamCaching() {
        StreamCachingInterceptor.noStreamCaching(this.interceptors);
        return this;
    }

    public RouteType streamCaching() {
        this.addInterceptor(new StreamCachingInterceptor());
        return this;
    }

    @Override
    public void addInterceptor(InterceptorType interceptor) {
        this.getInterceptors().add(interceptor);
    }
}

