/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.xml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeUtil {
    public static List<Element> getChildElements(Node node) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node next = childNodes.item(i);
            if (next.getNodeType() != 1) continue;
            result.add((Element)next);
        }
        return result;
    }

    public static List<Element> getDescendingElements(Node node, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeUtil.getDescendingElements(node, name, result);
        return result;
    }

    private static void getDescendingElements(Node node, String name, ArrayList<Element> result) {
        List<Element> allChildren = NodeUtil.getChildElements(node);
        int nofChildren = allChildren.size();
        for (int i = 0; i < nofChildren; ++i) {
            Element child = allChildren.get(i);
            if (child.getTagName().equals(name)) {
                result.add(child);
            }
            NodeUtil.getDescendingElements(child, name, result);
        }
    }

    public static List<Node> getDescendingNodes(Node node, String name) {
        ArrayList<Node> result = new ArrayList<Node>();
        List<Node> wantedChildren = NodeUtil.getChildNodes(node, name);
        result.addAll(wantedChildren);
        NodeList allChildren = node.getChildNodes();
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node child = allChildren.item(i);
            result.addAll(NodeUtil.getDescendingNodes(child, name));
        }
        return result;
    }

    public static List<Node> getChildNodes(Node node, String name) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node next = childNodes.item(i);
            if (!next.getNodeName().equals(name)) continue;
            result.add(next);
        }
        return result;
    }

    public static List<Element> getChildElements(Node node, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node next = childNodes.item(i);
            if (next.getNodeType() != 1 || !next.getNodeName().equals(name)) continue;
            result.add((Element)next);
        }
        return result;
    }

    public static Element getChildElement(Node node, String name) {
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getChildElement(Node node, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index should be > 0");
        }
        List<Element> childElements = NodeUtil.getChildElements(node);
        if (index >= childElements.size()) {
            return null;
        }
        return childElements.get(index);
    }

    public static Element getLastChildElement(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = childNodes.getLength() - 1; i >= 0; --i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static String getText(Node node) {
        StringBuilder buffer = new StringBuilder(100);
        NodeUtil.getText(node, buffer, false);
        return buffer.toString();
    }

    public static String getText(Node node, boolean spaces) {
        StringBuilder buffer = new StringBuilder(100);
        NodeUtil.getText(node, buffer, spaces);
        return buffer.toString();
    }

    public static void getText(Node node, StringBuilder buffer, boolean spaces) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                buffer.append(((Text)node).getData());
                if (!spaces) break;
                buffer.append(" ");
                break;
            }
            case 1: 
            case 9: {
                NodeList childNodes = node.getChildNodes();
                int length = childNodes.getLength();
                for (int i = 0; i < length; ++i) {
                    NodeUtil.getText(childNodes.item(i), buffer, spaces);
                }
                break;
            }
        }
    }

    public static String toLegalXMLString(String s) {
        return s;
    }

    public static void writeXML(Node node, OutputStream output) {
        PrintStream stream = new PrintStream(output);
        NodeUtil.writeXMLNode(node, stream);
    }

    public static void writeXMLNode(Node node, PrintStream output) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                NodeUtil.writeDocument((Document)node, output);
                break;
            }
            case 10: {
                NodeUtil.writeDocumentType((DocumentType)node, output);
                break;
            }
            case 11: {
                NodeUtil.writeDocumentFragment((DocumentFragment)node, output);
                break;
            }
            case 1: {
                NodeUtil.writeElement((Element)node, output);
                break;
            }
            case 2: {
                NodeUtil.writeAttribute((Attr)node, output);
                break;
            }
            case 3: {
                NodeUtil.writeText((Text)node, output);
                break;
            }
            case 4: {
                NodeUtil.writeCDATA((CDATASection)node, output);
                break;
            }
            case 6: {
                NodeUtil.writeEntity((Entity)node, output);
                break;
            }
            case 5: {
                NodeUtil.writeEntityReference((EntityReference)node, output);
                break;
            }
            case 7: {
                NodeUtil.writeProcessingInstruction((ProcessingInstruction)node, output);
                break;
            }
            case 8: {
                NodeUtil.writeComment((Comment)node, output);
                break;
            }
            case 12: {
                NodeUtil.writeNotation((Notation)node, output);
            }
        }
    }

    public static void writeDocument(Document document, PrintStream output) {
        output.print("<?xml version=\"1.0\"?>");
        NodeUtil.writeChildren(document, output);
    }

    public static void writeDocumentType(DocumentType documentType, PrintStream output) {
        output.print("<!DOCTYPE ");
        output.print(documentType.getName());
        output.print(" []>");
    }

    public static void writeDocumentFragment(DocumentFragment documentFragment, PrintStream output) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static void writeElement(Element element, PrintStream output) {
        output.print("<" + element.getTagName());
        NamedNodeMap atts = element.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            output.print(" ");
            NodeUtil.writeAttribute((Attr)atts.item(i), output);
        }
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            output.print("/>");
        } else if (children.getLength() == 1 && children.item(0).getNodeType() == 3) {
            output.print(">" + ((Text)children.item(0)).getData());
            output.print("</" + element.getTagName() + ">");
        } else {
            output.print(">");
            NodeUtil.writeChildren(element, output);
            output.print("</" + element.getTagName() + ">");
        }
    }

    public static void writeAttribute(Attr attribute, PrintStream output) {
        output.print(attribute.getName() + "=\"" + attribute.getValue() + "\"");
    }

    public static void writeText(Text text, PrintStream output) {
        output.print(text.getData());
    }

    public static void writeCDATA(CDATASection cdata, PrintStream output) {
        output.print("<![CDATA[" + cdata.getData() + "]]>");
    }

    public static void writeEntity(Entity entity, PrintStream output) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static void writeEntityReference(EntityReference entityReference, PrintStream output) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static void writeProcessingInstruction(ProcessingInstruction instr, PrintStream output) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static void writeComment(Comment comment, PrintStream output) {
        output.print("<!-- " + comment.getData() + " -->");
    }

    public static void writeNotation(Notation notation, PrintStream output) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static void writeChildren(Node node, PrintStream output) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            NodeUtil.writeXMLNode(list.item(i), output);
        }
    }
}

