/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.ManagementAgent;
import org.eclipse.smila.ontology.SesameOntologyManager;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.rdfxml.util.RDFXMLPrettyWriter;

public class SesameOntologyAgent
implements ManagementAgent {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final SesameOntologyManager _ontology;

    public SesameOntologyAgent(SesameOntologyManager ontology) {
        this._ontology = ontology;
    }

    public List<String> getRepositoryNames() {
        return this._ontology.getRepositoryNames();
    }

    public long getSize(String repositoryName) {
        long size;
        block5: {
            size = -1L;
            try {
                RepositoryConnection conn = this._ontology.getConnection(repositoryName);
                if (conn == null) break block5;
                try {
                    size = conn.size(new Resource[0]);
                }
                finally {
                    this.closeQuietly(conn);
                }
            }
            catch (Exception ex) {
                this._log.error((Object)("Error getting size of repository " + repositoryName), (Throwable)ex);
            }
        }
        return size;
    }

    public List<String> getContexts(String repositoryName) {
        ArrayList<String> result;
        block7: {
            result = new ArrayList<String>();
            try {
                RepositoryConnection conn = this._ontology.getConnection(repositoryName);
                if (conn == null) break block7;
                try {
                    RepositoryResult contexts = conn.getContextIDs();
                    if (contexts != null) {
                        while (contexts.hasNext()) {
                            Resource context = (Resource)contexts.next();
                            result.add(context.stringValue());
                        }
                    }
                }
                finally {
                    this.closeQuietly(conn);
                }
            }
            catch (Exception ex) {
                this._log.error((Object)("Error getting contexts of repository " + repositoryName), (Throwable)ex);
            }
        }
        return result;
    }

    public Map<String, String> getNamespaces(String repositoryName) {
        HashMap<String, String> result;
        block7: {
            result = new HashMap<String, String>();
            try {
                RepositoryConnection conn = this._ontology.getConnection(repositoryName);
                if (conn == null) break block7;
                try {
                    RepositoryResult namespaces = conn.getNamespaces();
                    if (namespaces != null) {
                        while (namespaces.hasNext()) {
                            Namespace namespace = (Namespace)namespaces.next();
                            result.put(namespace.getPrefix(), namespace.getName());
                        }
                    }
                }
                finally {
                    this.closeQuietly(conn);
                }
            }
            catch (Exception ex) {
                this._log.error((Object)("Error getting namespaces of repository " + repositoryName), (Throwable)ex);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String clear(String repositoryName) {
        RepositoryConnection conn = this._ontology.getConnection(repositoryName);
        if (conn == null) return "No repository named [" + repositoryName + "] exists.";
        try {
            long startSize = conn.size(new Resource[0]);
            conn.clear(new Resource[0]);
            conn.commit();
            long endSize = conn.size(new Resource[0]);
            String string = "Cleared repository [" + repositoryName + "], deleted " + (startSize - endSize) + " statements, " + endSize + " statements remain.";
            this.closeQuietly(conn);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.closeQuietly(conn);
                throw throwable;
            }
            catch (Exception ex) {
                return "Error: " + ex.toString();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String importRDF(String repositoryName, String filename, String baseUri) {
        RepositoryConnection conn = this._ontology.getConnection(repositoryName);
        if (conn == null) return "No repository named [" + repositoryName + "] exists.";
        try {
            long startSize = conn.size(new Resource[0]);
            RDFFormat format = RDFFormat.forFileName((String)filename, (RDFFormat)RDFFormat.RDFXML);
            conn.add(new File(filename), baseUri, format, new Resource[0]);
            conn.commit();
            long endSize = conn.size(new Resource[0]);
            String string = "Imported [" + filename + "] (format " + format.getName() + ") into repository [" + repositoryName + "], added " + (endSize - startSize) + " statements.";
            this.closeQuietly(conn);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.closeQuietly(conn);
                throw throwable;
            }
            catch (Exception ex) {
                return "Error: " + ex.toString();
            }
        }
    }

    public String exportRDF(String repositoryName, String filename) {
        String string;
        FileOutputStream stream;
        RepositoryConnection conn;
        block7: {
            conn = null;
            stream = null;
            conn = this._ontology.getConnection(repositoryName);
            if (conn == null) break block7;
            stream = new FileOutputStream(filename);
            RDFFormat format = RDFFormat.forFileName((String)filename, (RDFFormat)RDFFormat.RDFXML);
            RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format);
            Object writer = null;
            writer = factory == null ? new RDFXMLPrettyWriter((OutputStream)stream) : factory.getWriter((OutputStream)stream);
            conn.export((RDFHandler)writer, new Resource[0]);
            if (writer instanceof RDFXMLPrettyWriter) {
                ((RDFXMLPrettyWriter)writer).close();
            } else {
                stream.close();
            }
            String string2 = "Successfully exported repository [" + repositoryName + "] to file [" + filename + "] (format " + format.getName() + ")";
            IOUtils.closeQuietly((OutputStream)stream);
            this.closeQuietly(conn);
            return string2;
        }
        try {
            string = "No repository named [" + repositoryName + "] exists.";
        }
        catch (Exception ex) {
            String string3;
            try {
                string3 = "Error: " + ex.toString();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                this.closeQuietly(conn);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)stream);
            this.closeQuietly(conn);
            return string3;
        }
        IOUtils.closeQuietly((OutputStream)stream);
        this.closeQuietly(conn);
        return string;
    }

    private void closeQuietly(RepositoryConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (RepositoryException repositoryException) {}
        }
    }
}

