/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import java.io.File;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;

public class CreateFileUriPipelet
implements Pipelet {
    public static final String KEY_CONFIG_FILENAME_ATTRIBUTE = "_filenameAttribute";
    private String _sourceFilenameAttribute;
    private final Log _log = LogFactory.getLog(this.getClass());

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String filename;
                String id = stringArray[n2];
                if (this._sourceFilenameAttribute != null) {
                    try {
                        filename = blackboard.getMetadata(id).getStringValue(this._sourceFilenameAttribute);
                    }
                    catch (BlackboardAccessException e) {
                        throw new ProcessingException("Cannot access source filename attribute '" + this._sourceFilenameAttribute + "' of record '" + id + "'.", (Throwable)e);
                    }
                } else {
                    filename = id.replace("*.:<", "").replace(">.*", "").replace('\\', '/');
                }
                try {
                    File file = new File(filename);
                    URI fileUri = file.toURI();
                    AnyMap metadata = blackboard.getMetadata(id);
                    metadata.put((Object)"rdf:about", (Object)metadata.getFactory().createStringValue(fileUri.toString()));
                }
                catch (Exception ex) {
                    throw new ProcessingException("error creating file URI from key " + filename, (Throwable)ex);
                }
                ++n2;
            }
        }
        return recordIds;
    }

    public void configure(AnyMap configuration) throws ProcessingException {
        this._sourceFilenameAttribute = configuration.getStringValue(KEY_CONFIG_FILENAME_ATTRIBUTE);
        if (this._sourceFilenameAttribute == null) {
            this._log.error((Object)"Could not determine source attribute for filename.");
        }
    }
}

