/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.queue.BrokerException;
import org.eclipse.smila.connectivity.queue.ConnectivityBroker;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;

public abstract class AbstractBrokerPropertiesConfigImpl
implements ConnectivityBroker {
    protected static final String CONFIG_JMS_NAME = "jms.properties";
    protected static final String PROPERTY_PROVIDER_URL = "java.naming.provider.url";
    protected static final String PROPERTY_DEFAULT_DIRECTORY_PREFIX = "org.apache.activemq.default.directory.prefix";
    protected static final String DLQ = "ActiveMQ.DLQ";
    protected Session _session;
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected Connection _connection;

    protected abstract String getBundleId();

    @Override
    public synchronized void start() throws BrokerException {
        Properties properties;
        try {
            properties = this.loadJMSProperties();
        }
        catch (Exception e) {
            throw new BrokerException("Unable to load JMS properties", e);
        }
        try {
            try {
                InitialContext ctx = new InitialContext(properties);
                System.setProperty(PROPERTY_DEFAULT_DIRECTORY_PREFIX, properties.getProperty(PROPERTY_DEFAULT_DIRECTORY_PREFIX));
                ConnectionFactory factory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
                this._connection = factory.createConnection();
                this._connection.start();
                this._session = this._connection.createSession(true, 0);
                this._session.createQueue(DLQ);
            }
            catch (Exception e) {
                throw new BrokerException("Error initializing Queue Broker with JMS properties resp. configuration", e);
            }
        }
        catch (Throwable throwable) {
            if (this._session != null) {
                try {
                    this._session.commit();
                }
                catch (JMSException jMSException) {}
                try {
                    this._session.close();
                }
                catch (JMSException jMSException) {}
            }
            throw throwable;
        }
        if (this._session != null) {
            try {
                this._session.commit();
            }
            catch (JMSException jMSException) {}
            try {
                this._session.close();
            }
            catch (JMSException jMSException) {}
        }
    }

    private Properties loadJMSProperties() throws IOException {
        InputStream inputStream = ConfigUtils.getConfigStream((String)this.getBundleId(), (String)CONFIG_JMS_NAME);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (!properties.containsKey(PROPERTY_DEFAULT_DIRECTORY_PREFIX)) {
            File folder = WorkspaceHelper.createWorkingDir((String)this.getBundleId());
            String path = folder.getPath();
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            properties.put(PROPERTY_DEFAULT_DIRECTORY_PREFIX, path);
        }
        return properties;
    }

    @Override
    public synchronized void stop() {
        if (this._session != null) {
            try {
                this._session.close();
            }
            catch (JMSException e) {
                this._log.error((Object)"", (Throwable)e);
            }
            this._session = null;
        }
        if (this._connection != null) {
            try {
                this._connection.stop();
            }
            catch (JMSException e) {
                this._log.error((Object)"", (Throwable)e);
            }
            this._connection = null;
        }
    }
}

