/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.indexstructure;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.search.utils.indexstructure.DIndexStructure;
import org.eclipse.smila.search.utils.indexstructure.ISException;
import org.w3c.dom.Element;

public abstract class IndexStructureAccess {
    public static final String EXTENSION_POINT_NAME_INDEX_STRUCTURE_ACCESS = "org.eclipse.smila.search.utils.indexstructure.access";
    private static IndexStructureAccess[] s_cachedIndexStructureAccess;

    protected IndexStructureAccess() {
    }

    public static IndexStructureAccess getInstance() {
        IndexStructureAccess[] types;
        block5: {
            Log log = LogFactory.getLog(IndexStructureAccess.class);
            try {
                types = IndexStructureAccess.getTypes();
                if (types.length == 1) break block5;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("invalid index structure access count [" + types.length + "]"));
                }
                return null;
            }
            catch (ISException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                return null;
            }
        }
        return types[0];
    }

    public static IndexStructureAccess[] getTypes() throws ISException {
        if (s_cachedIndexStructureAccess != null) {
            return s_cachedIndexStructureAccess;
        }
        Log log = LogFactory.getLog(IndexStructureAccess.class);
        ArrayList<IndexStructureAccess> found = new ArrayList<IndexStructureAccess>();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_NAME_INDEX_STRUCTURE_ACCESS).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configurationElement = configElements[j];
                IndexStructureAccess.parseType(configurationElement, found.size());
                IndexStructureAccess clazz = null;
                try {
                    Object obj = configurationElement.createExecutableExtension("Clazz");
                    clazz = (IndexStructureAccess)obj;
                }
                catch (Exception exception) {
                    if (log.isErrorEnabled()) {
                        if (configurationElement != null) {
                            log.error((Object)"Failed to instantiate index structure access");
                        } else {
                            log.error((Object)"Unknown!");
                        }
                    }
                    throw new ISException("unable to load index structure access", exception);
                }
                if (clazz != null) {
                    found.add(clazz);
                }
                ++j;
            }
            ++i;
        }
        s_cachedIndexStructureAccess = found.toArray(new IndexStructureAccess[0]);
        return s_cachedIndexStructureAccess;
    }

    public static String parseType(IConfigurationElement configurationElement, int ordinal) {
        if (!configurationElement.getName().equals("IndexStructureAccess")) {
            return null;
        }
        Log log = LogFactory.getLog(IndexStructureAccess.class);
        try {
            String name = configurationElement.getAttribute("Clazz");
            if (name == null) {
                name = "[missing attribute name]";
            }
            return name;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                String name = configurationElement.getAttribute("Clazz");
                if (name == null) {
                    name = "[missing attribute name]";
                }
                String msg = "Failed to load StrategyType named " + name + " in " + configurationElement.getDeclaringExtension().getNamespaceIdentifier();
                log.error((Object)msg, (Throwable)e);
            }
            return null;
        }
    }

    public abstract boolean dataTypeMatches(String var1, String var2);

    public abstract DIndexStructure decode(Element var1) throws ISException;

    public abstract Element encode(DIndexStructure var1, Element var2) throws ISException;
}

