/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.search;

import java.util.Enumeration;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DFieldCodec;
import org.eclipse.smila.search.utils.search.DQuery;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DQueryCodec {
    protected static DQuery decode(Element element) throws DSearchException {
        DQuery dQuery = new DQuery();
        dQuery.setIndexName(element.getAttribute("IndexName"));
        dQuery.setMaxHits(Integer.parseInt(element.getAttribute("MaxHits")));
        dQuery.setMinSimilarity(Integer.parseInt(element.getAttribute("MinSimilarity")));
        dQuery.setShowHitDistribution(Boolean.valueOf(element.getAttribute("ShowHitDistribution")));
        if (element.hasAttribute("TemplateSelectorName")) {
            dQuery.setTemplateSelectorName(element.getAttribute("TemplateSelectorName"));
        }
        if (element.hasAttribute("StartHits")) {
            dQuery.setStartHits(new Integer(element.getAttribute("StartHits")));
        }
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Field".equals(nl.item(i).getLocalName())) {
                dQuery.addField(DFieldCodec.decode((Element)nl.item(i)));
            }
            ++i;
        }
        return dQuery;
    }

    protected static Element encode(DQuery dQuery, Element element) throws DSearchException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/Search", "Query");
        el.setAttribute("IndexName", dQuery.getIndexName());
        el.setAttribute("MaxHits", String.valueOf(dQuery.getMaxHits()));
        el.setAttribute("MinSimilarity", String.valueOf(dQuery.getMinSimilarity()));
        el.setAttribute("ShowHitDistribution", dQuery.getShowHitDistribution() ? "true" : "false");
        if (dQuery.getTemplateSelectorName() != null && !dQuery.getTemplateSelectorName().trim().equals("")) {
            el.setAttribute("TemplateSelectorName", dQuery.getTemplateSelectorName());
        }
        if (dQuery.getStartHits() != null) {
            el.setAttribute("StartHits", dQuery.getStartHits().toString());
        }
        Enumeration enumeration = dQuery.getFields();
        while (enumeration.hasMoreElements()) {
            DFieldCodec.encode((DField)enumeration.nextElement(), el);
        }
        element.appendChild(el);
        return el;
    }
}

