/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rtrep.v1.ACTIVITY;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v1.ChildInfo;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OExpression;
import org.apache.ode.bpel.rtrep.v1.OForEach;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.SCOPE;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannel;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.stl.FilterIterator;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.stl.UnaryFunction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOREACH
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(FOREACH.class);
    private OForEach _oforEach;
    private Set<ChildInfo> _children = new HashSet<ChildInfo>();
    private Set<CompensationHandler> _compHandlers = new HashSet<CompensationHandler>();
    private int _startCounter = -1;
    private int _finalCounter = -1;
    private int _currentCounter = -1;
    private int _completedCounter = 0;
    private int _completionCounter = -1;

    public FOREACH(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
        this._oforEach = (OForEach)activityInfo.o;
    }

    public void run() {
        try {
            this._startCounter = this.evaluateCondition(this._oforEach.startCounterValue);
            this._finalCounter = this.evaluateCondition(this._oforEach.finalCounterValue);
            if (this._oforEach.completionCondition != null) {
                this._completionCounter = this.evaluateCondition(this._oforEach.completionCondition.branchCount);
            }
            this._currentCounter = this._startCounter;
        }
        catch (FaultException faultException) {
            __log.error((Object)faultException);
            this._self.parent.completed(this.createFault(faultException.getQName(), this._self.o), this._compHandlers);
            return;
        }
        if (this._completionCounter > 0 && this._completionCounter > this._finalCounter - this._startCounter) {
            this._self.parent.completed(this.createFault(this._oforEach.getOwner().constants.qnInvalidBranchCondition, this._self.o), this._compHandlers);
            return;
        }
        if (this._finalCounter < this._startCounter || this._completionCounter == 0) {
            this._self.parent.completed(null, this._compHandlers);
        } else {
            if (this._oforEach.parallel) {
                for (int i = this._startCounter; i <= this._finalCounter; ++i) {
                    this.newChild();
                }
            } else {
                this.newChild();
            }
            FOREACH.instance((JacobRunnable)new ACTIVE());
        }
    }

    private boolean shouldContinue() {
        boolean bl = false;
        if (this._completionCounter > 0) {
            bl = this._completedCounter >= this._completionCounter || bl;
        }
        bl = this._startCounter + this._completedCounter > this._finalCounter || bl;
        return !bl;
    }

    private int evaluateCondition(OExpression oExpression) throws FaultException {
        return this.getBpelRuntime().getExpLangRuntime().evaluateAsNumber(oExpression, this.getEvaluationContext()).intValue();
    }

    private void newChild() {
        ChildInfo childInfo = new ChildInfo(new ActivityInfo(this.genMonotonic(), this._oforEach.innerScope, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class)));
        this._children.add(childInfo);
        Document document = DOMUtils.newDocument();
        Text text = document.createTextNode("" + this._currentCounter++);
        ScopeFrame scopeFrame = new ScopeFrame(this._oforEach.innerScope, this.getBpelRuntime().createScopeInstance(this._scopeFrame.scopeInstanceId, this._oforEach.innerScope), this._scopeFrame, null);
        VariableInstance variableInstance = scopeFrame.resolve(this._oforEach.counterVariable);
        try {
            this.initializeVariable(variableInstance, text);
        }
        catch (ExternalVariableModuleException externalVariableModuleException) {
            __log.error((Object)"Exception while initializing external variable", (Throwable)externalVariableModuleException);
            this._self.parent.failure(externalVariableModuleException.toString(), null);
            return;
        }
        VariableModificationEvent variableModificationEvent = new VariableModificationEvent(variableInstance.declaration.name);
        variableModificationEvent.setNewValue((Node)text);
        if (this._oforEach.debugInfo != null) {
            variableModificationEvent.setLineNo(this._oforEach.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)variableModificationEvent);
        FOREACH.instance((JacobRunnable)new SCOPE(childInfo.activity, scopeFrame, this._linkFrame));
    }

    public String toString() {
        return "<T:Act:Flow:" + this._oforEach.name + ">";
    }

    private Iterator<ChildInfo> active() {
        return new FilterIterator(this._children.iterator(), (UnaryFunction)new MemberOfFunction<ChildInfo>(){

            public boolean isMember(ChildInfo childInfo) {
                return !childInfo.completed;
            }
        });
    }

    private class ACTIVE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -5642862698981385732L;
        private FaultData _fault;
        private boolean _terminateRequested = false;

        private ACTIVE() {
        }

        public void run() {
            Iterator iterator = FOREACH.this.active();
            if (FOREACH.this.active().hasNext()) {
                HashSet<ChannelListener> hashSet = new HashSet<ChannelListener>();
                hashSet.add(new TerminationChannelListener(FOREACH.this._self.self){
                    private static final long serialVersionUID = 2554750257484084466L;

                    public void terminate() {
                        Iterator iterator = FOREACH.this.active();
                        while (iterator.hasNext()) {
                            ((TerminationChannel)1.replication((Channel)((ChildInfo)iterator.next()).activity.self)).terminate();
                        }
                        ACTIVE.this._terminateRequested = true;
                        1.instance((JacobRunnable)ACTIVE.this);
                    }
                });
                while (iterator.hasNext()) {
                    final ChildInfo childInfo = (ChildInfo)iterator.next();
                    hashSet.add(new ParentScopeChannelListener(childInfo.activity.parent){
                        private static final long serialVersionUID = -8027205709961438172L;

                        @Override
                        public void compensate(OScope oScope, SynchChannel synchChannel) {
                            FOREACH.this._self.parent.compensate(oScope, synchChannel);
                            2.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> set) {
                            childInfo.completed = true;
                            if (FOREACH.this._completionCounter > 0 && ((FOREACH)FOREACH.this)._oforEach.completionCondition.successfulBranchesOnly) {
                                if (faultData != null) {
                                    FOREACH.this._completedCounter++;
                                }
                            } else {
                                FOREACH.this._completedCounter++;
                            }
                            FOREACH.this._compHandlers.addAll(set);
                            if (faultData != null && ACTIVE.this._fault == null) {
                                ACTIVE.this._fault = faultData;
                            }
                            if (FOREACH.this.shouldContinue() && ACTIVE.this._fault == null && !ACTIVE.this._terminateRequested) {
                                if (!((FOREACH)FOREACH.this)._oforEach.parallel) {
                                    FOREACH.this.newChild();
                                }
                            } else {
                                Iterator iterator = FOREACH.this.active();
                                while (iterator.hasNext()) {
                                    ((TerminationChannel)2.replication((Channel)((ChildInfo)iterator.next()).activity.self)).terminate();
                                }
                            }
                            2.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String string, Element element) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                ACTIVE.object((boolean)false, hashSet);
            } else {
                FOREACH.this._self.parent.completed(this._fault, FOREACH.this._compHandlers);
            }
        }
    }
}

