/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.ScopeFaultEvent;
import org.apache.ode.bpel.evt.ScopeStartEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rapi.InvalidProcessException;
import org.apache.ode.bpel.rtrep.v1.ACTIVITY;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.COMPENSATIONHANDLER_;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.EH_ALARM;
import org.apache.ode.bpel.rtrep.v1.EH_EVENT;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OCatch;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OEventHandler;
import org.apache.ode.bpel.rtrep.v1.OFailureHandling;
import org.apache.ode.bpel.rtrep.v1.OFaultHandler;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.ORDEREDCOMPENSATOR;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.bpel.rtrep.v1.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.CompensationChannel;
import org.apache.ode.bpel.rtrep.v1.channels.EventHandlerControlChannel;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannel;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SCOPE
extends ACTIVITY {
    private static final long serialVersionUID = 6111903798996023525L;
    private static final Log __log = LogFactory.getLog(SCOPE.class);
    private OScope _oscope;
    private ActivityInfo _child;
    private Set<EventHandlerInfo> _eventHandlers = new HashSet<EventHandlerInfo>();

    public SCOPE(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
        this._oscope = (OScope)activityInfo.o;
        assert (this._oscope.activity != null);
    }

    public void run() {
        this._child = new ActivityInfo(this.genMonotonic(), this._oscope.activity, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
        SCOPE.instance((JacobRunnable)this.createChild(this._child, this._scopeFrame, this._linkFrame));
        if (this._oscope.eventHandler != null) {
            EventHandlerInfo eventHandlerInfo;
            for (OEventHandler.OAlarm oAgent : this._oscope.eventHandler.onAlarms) {
                eventHandlerInfo = new EventHandlerInfo(oAgent, (EventHandlerControlChannel)this.newChannel(EventHandlerControlChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class), (TerminationChannel)this.newChannel(TerminationChannel.class));
                this._eventHandlers.add(eventHandlerInfo);
                SCOPE.instance((JacobRunnable)new EH_ALARM(eventHandlerInfo.psc, eventHandlerInfo.tc, eventHandlerInfo.cc, oAgent, this._scopeFrame));
            }
            for (OEventHandler.OEvent oEvent : this._oscope.eventHandler.onMessages) {
                eventHandlerInfo = new EventHandlerInfo(oEvent, (EventHandlerControlChannel)this.newChannel(EventHandlerControlChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class), (TerminationChannel)this.newChannel(TerminationChannel.class));
                this._eventHandlers.add(eventHandlerInfo);
                SCOPE.instance((JacobRunnable)new EH_EVENT(eventHandlerInfo.psc, eventHandlerInfo.tc, eventHandlerInfo.cc, oEvent, this._scopeFrame));
            }
        }
        this.getBpelRuntime().initializePartnerLinks(this._scopeFrame.scopeInstanceId, this._oscope.partnerLinks.values());
        this.sendEvent((ScopeEvent)new ScopeStartEvent());
        SCOPE.instance((JacobRunnable)new ACTIVE());
    }

    private List<CompensationHandler> findCompensationData(OScope oScope) {
        ArrayList<CompensationHandler> arrayList = new ArrayList<CompensationHandler>();
        for (CompensationHandler compensationHandler : this._scopeFrame.availableCompensations) {
            if (null != oScope && !compensationHandler.compensated.oscope.equals(oScope)) continue;
            arrayList.add(compensationHandler);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static OCatch findCatch(OFaultHandler oFaultHandler, QName qName, OVarType oVarType) {
        OCatch oCatch = null;
        for (OCatch oCatch2 : oFaultHandler.catchBlocks) {
            int n;
            if (oCatch2.faultName != null && (qName == null || !qName.equals(oCatch2.faultName)) || oCatch2.faultVariable != null && (oVarType == null || !(oCatch2.faultVariable.type instanceof OMessageVarType ? oVarType instanceof OMessageVarType && ((OMessageVarType)oVarType).equals(oCatch2.faultVariable.type) || oVarType instanceof OElementVarType && ((OMessageVarType)oCatch2.faultVariable.type).docLitType != null && !((OMessageVarType)oCatch2.faultVariable.type).docLitType.equals(oVarType) : oCatch2.faultVariable.type instanceof OElementVarType && (oVarType instanceof OElementVarType && oVarType.equals(oCatch2.faultVariable.type) || oVarType instanceof OMessageVarType && ((OMessageVarType)oVarType).docLitType != null && ((OMessageVarType)oVarType).docLitType.equals(oCatch2.faultVariable.type))))) continue;
            if (oCatch == null) {
                oCatch = oCatch2;
                continue;
            }
            int n2 = (oCatch2.faultName == null ? 0 : 2) + (oCatch2.faultVariable == null ? 0 : 1);
            if (n2 <= (n = (oCatch.faultName == null ? 0 : 2) + (oCatch.faultVariable == null ? 0 : 1))) continue;
            oCatch = oCatch2;
        }
        return oCatch;
    }

    static final class EventHandlerInfo
    implements Serializable {
        private static final long serialVersionUID = -9046603073542446478L;
        final OBase o;
        final EventHandlerControlChannel cc;
        final ParentScopeChannel psc;
        final TerminationChannel tc;
        boolean terminateRequested;
        boolean stopRequested;

        EventHandlerInfo(OBase oBase, EventHandlerControlChannel eventHandlerControlChannel, ParentScopeChannel parentScopeChannel, TerminationChannel terminationChannel) {
            this.o = oBase;
            this.cc = eventHandlerControlChannel;
            this.psc = parentScopeChannel;
            this.tc = terminationChannel;
        }
    }

    class ACTIVE
    extends ACTIVITY {
        private static final long serialVersionUID = -5876892592071965346L;
        private boolean _terminated;
        private FaultData _fault;
        private long _startTime;
        private final HashSet<CompensationHandler> _compensations;
        private boolean _childTermRequested;

        ACTIVE() {
            super(SCOPE.this._self, SCOPE.this._scopeFrame, SCOPE.this._linkFrame);
            this._compensations = new HashSet();
            this._startTime = System.currentTimeMillis();
        }

        public void run() {
            if (SCOPE.this._child != null || !SCOPE.this._eventHandlers.isEmpty()) {
                HashSet<ChannelListener> hashSet = new HashSet<ChannelListener>();
                hashSet.add(new TerminationChannelListener(this._self.self){
                    private static final long serialVersionUID = 1913414844895865116L;

                    public void terminate() {
                        ACTIVE.this._terminated = true;
                        if (SCOPE.this._child != null && !ACTIVE.this._childTermRequested) {
                            ((TerminationChannel)1.replication((Channel)((SCOPE)SCOPE.this)._child.self)).terminate();
                            ACTIVE.this._childTermRequested = true;
                        }
                        ACTIVE.this.terminateEventHandlers();
                        1.instance((JacobRunnable)ACTIVE.this);
                    }
                });
                if (SCOPE.this._child != null) {
                    hashSet.add(new ParentScopeChannelListener(((SCOPE)SCOPE.this)._child.parent){
                        private static final long serialVersionUID = -6934246487304813033L;

                        @Override
                        public void compensate(OScope oScope, SynchChannel synchChannel) {
                            if (ACTIVE.this._scopeFrame.availableCompensations == null) {
                                ACTIVE.this._self.parent.compensate(oScope, synchChannel);
                            } else {
                                List list = SCOPE.this.findCompensationData(oScope);
                                ACTIVE.this._scopeFrame.availableCompensations.removeAll(list);
                                2.instance((JacobRunnable)new ORDEREDCOMPENSATOR(list, synchChannel));
                            }
                            2.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> set) {
                            if (faultData != null && ACTIVE.this._fault == null) {
                                ACTIVE.this._fault = faultData;
                            }
                            SCOPE.this._child = null;
                            ACTIVE.this._compensations.addAll(set);
                            if (faultData == null) {
                                ACTIVE.this.stopEventHandlers();
                            } else {
                                ACTIVE.this.terminateEventHandlers();
                            }
                            2.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void cancelled() {
                            if (((SCOPE)SCOPE.this)._oscope.implicitScope) {
                                ACTIVE.this._self.parent.cancelled();
                            } else {
                                this.completed(null, CompensationHandler.emptySet());
                            }
                        }

                        @Override
                        public void failure(String string, Element element) {
                            this.completed(ACTIVE.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, ACTIVE.this._self.o, null), CompensationHandler.emptySet());
                        }
                    });
                }
                for (final EventHandlerInfo eventHandlerInfo : SCOPE.this._eventHandlers) {
                    hashSet.add(new ParentScopeChannelListener(eventHandlerInfo.psc){
                        private static final long serialVersionUID = -4694721357537858221L;

                        @Override
                        public void compensate(OScope oScope, SynchChannel synchChannel) {
                            ACTIVE.this._self.parent.compensate(oScope, synchChannel);
                            3.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> set) {
                            if (faultData != null && ACTIVE.this._fault == null) {
                                ACTIVE.this._fault = faultData;
                            }
                            SCOPE.this._eventHandlers.remove(eventHandlerInfo);
                            ACTIVE.this._compensations.addAll(set);
                            if (faultData != null) {
                                if (SCOPE.this._child != null && !ACTIVE.this._childTermRequested) {
                                    ((TerminationChannel)3.replication((Channel)((SCOPE)SCOPE.this)._child.self)).terminate();
                                    ACTIVE.this._childTermRequested = true;
                                }
                                ACTIVE.this.terminateEventHandlers();
                            } else {
                                ACTIVE.this.stopEventHandlers();
                            }
                            3.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String string, Element element) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                ACTIVE.object((boolean)false, hashSet);
            } else {
                Set<CompensationHandler> set = this._scopeFrame.availableCompensations;
                if (set != null) {
                    for (CompensationHandler object2 : set) {
                        object2.compChannel.forget();
                    }
                }
                this._scopeFrame.availableCompensations = null;
                HashSet hashSet = new HashSet();
                if (((SCOPE)SCOPE.this)._oscope.faultHandler != null) {
                    Iterator<OCatch> iterator = ((SCOPE)SCOPE.this)._oscope.faultHandler.catchBlocks.iterator();
                    while (iterator.hasNext()) {
                        hashSet.addAll(iterator.next().outgoingLinks);
                    }
                }
                if (this._terminated) {
                    __log.debug((Object)("Scope: " + SCOPE.this._oscope + " was terminated."));
                    this._self.parent.completed(null, this._compensations);
                } else if (this._fault != null) {
                    OCatch oCatch;
                    this.sendEvent((ScopeEvent)new ScopeFaultEvent(this._fault.getFaultName(), this._fault.getFaultLineNo(), this._fault.getExplanation()));
                    OCatch oCatch2 = oCatch = ((SCOPE)SCOPE.this)._oscope.faultHandler == null ? null : SCOPE.findCatch(((SCOPE)SCOPE.this)._oscope.faultHandler, this._fault.getFaultName(), this._fault.getFaultType());
                    assert (SCOPE.this._eventHandlers.isEmpty());
                    assert (SCOPE.this._child == null);
                    if (oCatch == null) {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)(this._self + ": has no fault handler for " + this._fault.getFaultName() + "; scope will propagate FAULT!"));
                        }
                        this._self.parent.completed(this._fault, this._compensations);
                    } else {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)(this._self + ": has a fault handler for " + this._fault.getFaultName() + ": " + oCatch));
                        }
                        hashSet.removeAll(oCatch.outgoingLinks);
                        OdeInternalInstance odeInternalInstance = this.getBpelRuntime();
                        ActivityInfo activityInfo = new ActivityInfo(this.genMonotonic(), oCatch, (TerminationChannel)this.newChannel(TerminationChannel.class, "FH"), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class, "FH"));
                        ScopeFrame scopeFrame = new ScopeFrame(oCatch, odeInternalInstance.createScopeInstance(this._scopeFrame.scopeInstanceId, oCatch), this._scopeFrame, this._compensations, this._fault);
                        if (oCatch.faultVariable != null) {
                            try {
                                VariableInstance variableInstance = scopeFrame.resolve(oCatch.faultVariable);
                                this.initializeVariable(variableInstance, this._fault.getFaultMessage());
                                VariableModificationEvent variableModificationEvent = new VariableModificationEvent(variableInstance.declaration.name);
                                variableModificationEvent.setNewValue((Node)this._fault.getFaultMessage());
                                if (((SCOPE)SCOPE.this)._oscope.debugInfo != null) {
                                    variableModificationEvent.setLineNo(((SCOPE)SCOPE.this)._oscope.debugInfo.startLine);
                                }
                                this.sendEvent((ScopeEvent)variableModificationEvent);
                            }
                            catch (Exception exception) {
                                __log.fatal((Object)exception);
                                throw new InvalidProcessException(exception);
                            }
                        }
                        ACTIVE.instance((JacobRunnable)new SCOPE(activityInfo, scopeFrame, SCOPE.this._linkFrame));
                        ACTIVE.object((ChannelListener)new ParentScopeChannelListener(activityInfo.parent){
                            private static final long serialVersionUID = -6009078124717125270L;

                            @Override
                            public void compensate(OScope oScope, SynchChannel synchChannel) {
                                throw new AssertionError((Object)"received compensate request!");
                            }

                            @Override
                            public void completed(FaultData faultData, Set<CompensationHandler> set) {
                                for (CompensationHandler compensationHandler : set) {
                                    compensationHandler.compChannel.forget();
                                }
                                ACTIVE.this._self.parent.completed(faultData, CompensationHandler.emptySet());
                            }

                            @Override
                            public void cancelled() {
                                this.completed(null, CompensationHandler.emptySet());
                            }

                            @Override
                            public void failure(String string, Element element) {
                                this.completed(null, CompensationHandler.emptySet());
                            }
                        });
                    }
                } else if (((SCOPE)SCOPE.this)._oscope.compensationHandler != null) {
                    CompensationHandler compensationHandler = new CompensationHandler(this._scopeFrame, (CompensationChannel)this.newChannel(CompensationChannel.class), this._startTime, System.currentTimeMillis());
                    this._self.parent.completed(null, Collections.singleton(compensationHandler));
                    ACTIVE.instance((JacobRunnable)new COMPENSATIONHANDLER_(compensationHandler, this._compensations));
                } else {
                    this._self.parent.completed(null, this._compensations);
                }
                this.dpe(hashSet);
            }
        }

        private void terminateEventHandlers() {
            for (EventHandlerInfo eventHandlerInfo : SCOPE.this._eventHandlers) {
                if (eventHandlerInfo.terminateRequested || eventHandlerInfo.stopRequested) continue;
                ((TerminationChannel)ACTIVE.replication((Channel)eventHandlerInfo.tc)).terminate();
                eventHandlerInfo.terminateRequested = true;
            }
        }

        private void stopEventHandlers() {
            for (EventHandlerInfo eventHandlerInfo : SCOPE.this._eventHandlers) {
                if (eventHandlerInfo.stopRequested || eventHandlerInfo.terminateRequested) continue;
                eventHandlerInfo.cc.stop();
                eventHandlerInfo.stopRequested = true;
            }
        }
    }
}

