/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xpath10;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rtrep.v2.OBase;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLValueExpression;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OXslSheet;
import org.apache.ode.utils.NSContext;

public class OXPath10Expression
extends OLValueExpression
implements Serializable {
    private static final long serialVersionUID = -1L;
    public HashMap<String, OScope.Variable> vars = new HashMap();
    public final HashMap<String, OProcess.OProperty> properties = new HashMap();
    public final HashMap<String, OLink> links = new HashMap();
    public final HashMap<URI, OXslSheet> xslSheets = new HashMap();
    private final HashMap<SigGetVariableData, OSigGetVariableData> _getVariableDataSigs = new HashMap();
    public String xpath;
    public NSContext namespaceCtx;
    public final QName qname_getVariableData;
    public final QName qname_getVariableProperty;
    public final QName qname_getLinkStatus;

    public OXPath10Expression(OProcess oProcess, QName qName, QName qName2, QName qName3) {
        super(oProcess);
        this.qname_getLinkStatus = qName3;
        this.qname_getVariableData = qName;
        this.qname_getVariableProperty = qName2;
    }

    public OSigGetVariableData resolveGetVariableDataSig(String string, String string2, String string3) {
        SigGetVariableData sigGetVariableData = new SigGetVariableData(string, string2, string3);
        return this._getVariableDataSigs.get(sigGetVariableData);
    }

    public void addGetVariableDataSig(String string, String string2, String string3, OSigGetVariableData oSigGetVariableData) {
        this._getVariableDataSigs.put(new SigGetVariableData(string, string2, string3), oSigGetVariableData);
    }

    public String toString() {
        return "{OXPath10Expression " + this.xpath + "}";
    }

    public OScope.Variable getVariable() {
        if (this.vars.size() == 0) {
            throw new IllegalStateException("LValue must have one variable reference.");
        }
        for (String string : this.vars.keySet()) {
            if (!this.xpath.substring(1, this.xpath.length()).startsWith(string)) continue;
            return this.vars.get(string);
        }
        throw new IllegalStateException("Either the expression doesn't start with a variable reference or the reference is unknow.");
    }

    public static final class OSigGetVariableData
    extends OBase {
        private static final long serialVersionUID = -1L;
        public final OScope.Variable variable;
        public final OMessageVarType.Part part;
        public final OExpression location;

        public OSigGetVariableData(OProcess oProcess, OScope.Variable variable, OMessageVarType.Part part, OExpression oExpression) {
            super(oProcess);
            this.variable = variable;
            this.part = part;
            this.location = oExpression;
        }
    }

    private static final class SigGetVariableData
    implements Serializable {
        private static final long serialVersionUID = -1L;
        private final String varname;
        private final String partname;
        private final String location;

        private SigGetVariableData(String string, String string2, String string3) {
            this.varname = string;
            this.partname = string2;
            this.location = string3;
        }

        public boolean equals(Object object) {
            SigGetVariableData sigGetVariableData = (SigGetVariableData)object;
            if (!(this.varname == null || sigGetVariableData.varname != null && this.varname.equals(sigGetVariableData.varname))) {
                return false;
            }
            if (!(this.partname == null || sigGetVariableData.partname != null && this.partname.equals(sigGetVariableData.partname))) {
                return false;
            }
            return this.location == null || sigGetVariableData.location != null && this.location.equals(sigGetVariableData.location);
        }

        public int hashCode() {
            int n = 0;
            if (this.varname != null) {
                n ^= this.varname.hashCode();
            }
            if (this.partname != null) {
                n ^= this.partname.hashCode();
            }
            if (this.location != null) {
                n ^= this.location.hashCode();
            }
            return n;
        }
    }
}

