/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.index;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DConfiguration;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DDateField;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfig;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConstraints;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DNamedConfig;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DQueryConstraints;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.templates.TemplateException;
import org.eclipse.smila.search.templates.TemplateRegistryController;
import org.eclipse.smila.search.templates.messages.searchtemplates.DTemplate;
import org.eclipse.smila.search.utils.advsearch.IQueryExpression;
import org.eclipse.smila.search.utils.indexstructure.DIndexField;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DNumberField;
import org.eclipse.smila.search.utils.search.DQuery;
import org.eclipse.smila.search.utils.search.DTextField;
import org.eclipse.smila.search.utils.search.IDFParameter;
import org.eclipse.smila.search.utils.search.INFParameter;
import org.eclipse.smila.search.utils.search.ITFParameter;
import org.eclipse.smila.search.utils.searchresult.LuceneSearchResult;

public abstract class IndexConnection {
    protected DIndex _index;
    protected String _indexName;

    protected IndexConnection(String indexName) throws IndexException {
        try {
            this._index = DataDictionaryController.getIndex((String)indexName);
        }
        catch (DataDictionaryException e) {
            throw new IndexException(e.getMessage(), e);
        }
        if (this._index == null) {
            throw new IndexException("index not in data dictionary [" + indexName + "]");
        }
        this._indexName = indexName;
    }

    public String getName() {
        return this._indexName;
    }

    public DIndex getIndex() {
        return this._index;
    }

    protected abstract void close();

    public abstract boolean docExists(String var1) throws IndexException;

    public abstract void deleteDocument(String var1) throws IndexException;

    public abstract void learnDocument(Blackboard var1, String var2, Map<String, Integer> var3, Map<String, Integer> var4) throws IndexException, BlackboardAccessException;

    protected abstract void startBurstmode() throws IndexException;

    protected abstract void stopBurstmode() throws IndexException;

    public abstract IQueryExpression getSimpleSearchQuery(DQuery var1) throws IndexException, NodeTransformerException, TemplateException;

    protected abstract LuceneSearchResult doQuery(IQueryExpression var1, int var2) throws IndexException;

    protected abstract IQueryExpression getTestQueryExpression(String var1) throws IndexException;

    protected abstract void insertTextParameter(DTextField var1, ITFParameter var2, String var3, StringBuffer var4);

    protected abstract void insertNumberParameter(DNumberField var1, INFParameter var2, String var3, StringBuffer var4);

    protected abstract void insertDateParameter(org.eclipse.smila.search.utils.search.DDateField var1, IDFParameter var2, String var3, StringBuffer var4);

    protected abstract void getResultValues(String[] var1, int[] var2, String[][] var3) throws IndexException;

    protected abstract String[] getResultValues(String var1, int var2) throws IndexException;

    protected abstract void encodeTextField(DTextField var1) throws IndexException;

    protected abstract void isSupportedValue(int var1, Object var2) throws IndexException;

    public void validateQuery(DQuery dQuery) throws IndexException {
        Log log = LogFactory.getLog(this.getClass());
        Hashtable<Integer, DField> queryFields = new Hashtable<Integer, DField>();
        DConfiguration dConfig = this._index.getConfiguration();
        Enumeration fields = dQuery.getFields();
        while (fields.hasMoreElements()) {
            DField field = (DField)fields.nextElement();
            if (!this._index.getIndexStructure().hasField(field.getFieldNo())) {
                throw new IndexException("field in search query does not exist in index [" + field.getFieldNo() + "]");
            }
            if (!dConfig.getDefaultConfig().getField(field.getFieldNo()).getFieldConfig().getType().equals(field.getType())) {
                throw new IndexException("field type in search query does not match field type in index [" + field.getFieldNo() + "]");
            }
            DFieldConfig fc = null;
            if (field.getParameterDescriptor() != null) {
                DNamedConfig nc = null;
                if (!dConfig.hasNamedConfig(field.getParameterDescriptor())) {
                    log.error((Object)("unable to locate named config for index [" + dQuery.getIndexName() + ";" + field.getParameterDescriptor() + "]"));
                } else {
                    nc = dConfig.getNamedConfig(field.getParameterDescriptor());
                    if (nc != null && (fc = nc.getFieldConfig(field)) == null) {
                        log.error((Object)("unable to locate named config for index [" + dQuery.getIndexName() + ";" + field.getParameterDescriptor() + ";" + field.getType() + "]"));
                    }
                }
            }
            DFieldConfig defaultfc = dConfig.getDefaultConfig().getField(field.getFieldNo()).getFieldConfig();
            this.applyFieldConfig(field, fc, defaultfc);
            queryFields.put(new Integer(field.getFieldNo()), field);
        }
        DQueryConstraints queryConstraints = dConfig.getQueryConstraints();
        if (queryConstraints != null) {
            int i = 0;
            while (i < queryConstraints.getFieldConstraintsLength()) {
                DField field;
                DFieldConstraints dFieldConstraints = queryConstraints.getFieldConstraints(i);
                String occurrence = dFieldConstraints.getOccurrence();
                if (occurrence.equals("required")) {
                    if (!queryFields.containsKey(new Integer(dFieldConstraints.getFieldNo()))) {
                        throw new IndexException("query constraint requires field [" + dFieldConstraints.getFieldNo() + "]");
                    }
                } else if (occurrence.equals("prohibited") && queryFields.containsKey(new Integer(dFieldConstraints.getFieldNo()))) {
                    throw new IndexException("query constraint prohibits field [" + dFieldConstraints.getFieldNo() + "]");
                }
                if ((field = (DField)queryFields.get(new Integer(dFieldConstraints.getFieldNo()))) != null) {
                    int n;
                    int n2;
                    String[] stringArray;
                    boolean matchConstraint;
                    if (dFieldConstraints.getFieldTemplateCount() > 0) {
                        matchConstraint = false;
                        String[] fieldTemplates = dFieldConstraints.getFieldTemplates();
                        String fieldTemplate = field.getFieldTemplate() != null ? field.getFieldTemplate().trim() : "";
                        stringArray = fieldTemplates;
                        n2 = fieldTemplates.length;
                        n = 0;
                        while (n < n2) {
                            String fieldTemplate2 = stringArray[n];
                            if (fieldTemplate2.equals(fieldTemplate)) {
                                matchConstraint = true;
                                break;
                            }
                            ++n;
                        }
                        if (!matchConstraint) {
                            throw new IndexException("query field does not match field template constraint [" + field.getFieldNo() + "]");
                        }
                    }
                    if (dFieldConstraints.getNodeTransformerCount() > 0) {
                        matchConstraint = false;
                        String[] nodeTransformers = dFieldConstraints.getNodeTransformers();
                        String nodeTransformerName = field.getNodeTransformer() != null ? field.getNodeTransformer().getName() : "";
                        stringArray = nodeTransformers;
                        n2 = nodeTransformers.length;
                        n = 0;
                        while (n < n2) {
                            String nodeTransformer = stringArray[n];
                            if (nodeTransformer.equals(nodeTransformerName)) {
                                matchConstraint = true;
                                break;
                            }
                            ++n;
                        }
                        if (!matchConstraint) {
                            throw new IndexException("query field does not match node transformer constraint [" + field.getFieldNo() + "]");
                        }
                    }
                    if (dFieldConstraints.getConstraintCount() > 0) {
                        matchConstraint = false;
                        String[] constraints = dFieldConstraints.getConstraints();
                        String constraint = field.getConstraint() != null ? field.getConstraint() : "";
                        stringArray = constraints;
                        n2 = constraints.length;
                        n = 0;
                        while (n < n2) {
                            String constraint2 = stringArray[n];
                            if (constraint2.equals(constraint)) {
                                matchConstraint = true;
                                break;
                            }
                            ++n;
                        }
                        if (!matchConstraint) {
                            throw new IndexException("query field does not match constraint constraint [" + field.getFieldNo() + "]");
                        }
                    }
                }
                ++i;
            }
        }
        fields = dQuery.getFields();
        while (fields.hasMoreElements()) {
            DField field = (DField)fields.nextElement();
            if (!(field instanceof DTextField)) continue;
            this.encodeTextField((DTextField)field);
        }
    }

    public LuceneSearchResult doQuery(IQueryExpression dQE) throws IndexException {
        int startPos = dQE.getStartHits() == null ? 0 : dQE.getStartHits();
        LuceneSearchResult result = this.doQuery(dQE, startPos);
        return result;
    }

    public LuceneSearchResult doQuery(DQuery dQuery) throws IndexException {
        Log log = LogFactory.getLog(this.getClass());
        this.validateQuery(dQuery);
        try {
            DTemplate dTemplate = TemplateRegistryController.getTemplate(dQuery);
            IQueryExpression dQE = null;
            if (dTemplate != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("using template [" + dQuery.getIndexName() + ";" + dTemplate.getName() + "]"));
                }
                dQE = TemplateRegistryController.applyTemplate(dQuery, dTemplate, this);
            } else {
                dQE = this.getSimpleSearchQuery(dQuery);
            }
            LuceneSearchResult searchResult = this.doQuery(dQE, dQuery.getStartHits() != null ? dQuery.getStartHits() : 0);
            if (dQuery.getResultFields() != null) {
                this.addResultAttributes(dQuery.getResultFields(), searchResult);
            }
            if (dQuery.getHighlightFields() != null) {
                this.addHighlightResultAttributes(dQuery.getHighlightFields(), searchResult, dQE);
            }
            return searchResult;
        }
        catch (TemplateException e) {
            log.error((Object)"error while NQE transformation", (Throwable)e);
            throw new IndexException("unable to apply templates", e);
        }
        catch (NodeTransformerException e) {
            log.error((Object)"unable to perform node transformation", (Throwable)e);
            throw new IndexException("unable to perform node transformation", e);
        }
    }

    private void addResultAttributes(Collection<Integer> resultFields, LuceneSearchResult searchResult) throws IndexException {
        for (Record record : searchResult.getResultList()) {
            for (int fieldNo : resultFields) {
                AnySeq attributeValue;
                DIndexField field = this._index.getIndexStructure().getField(fieldNo);
                String name = field.getName();
                String[] values = this.getResultValues(record.getId(), fieldNo);
                if (values == null) continue;
                if (values.length == 1) {
                    attributeValue = this.createValue(record.getFactory(), fieldNo, values[0]);
                } else {
                    AnySeq seq;
                    attributeValue = seq = record.getFactory().createAnySeq();
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        seq.add((Object)this.createValue(record.getFactory(), fieldNo, value));
                        ++n2;
                    }
                }
                record.getMetadata().put((Object)name, (Object)attributeValue);
            }
        }
    }

    private void addHighlightResultAttributes(Collection<Integer> highlightFields, LuceneSearchResult searchResult, IQueryExpression dQE) throws IndexException {
        for (Record record : searchResult.getResultList()) {
            AnyMap highlight = record.getFactory().createAnyMap();
            record.getMetadata().put((Object)"_highlight", (Object)highlight);
            for (int fieldNo : highlightFields) {
                DIndexField field = this._index.getIndexStructure().getField(fieldNo);
                String name = field.getName();
                this.addHighlightAnnotation(dQE, record.getId(), highlight, fieldNo, name, searchResult.getIndexName());
            }
        }
    }

    protected abstract Value createValue(DataFactory var1, int var2, String var3) throws IndexException;

    protected abstract void addHighlightAnnotation(IQueryExpression var1, String var2, AnyMap var3, int var4, String var5, String var6) throws IndexException;

    public LuceneSearchResult doTestQuery(String text) throws IndexException {
        return this.doQuery(this.getTestQueryExpression(text), 0);
    }

    private void applyFieldConfig(DField field, DFieldConfig nc, DFieldConfig defaultfc) {
        Log log = LogFactory.getLog(this.getClass());
        StringBuffer sb = new StringBuffer("Processing parameters for search field [" + field.getFieldNo() + "]: ");
        if (nc == null) {
            sb = sb.append("[no named config] ");
        }
        if (field.getConstraint() == null) {
            if (nc == null || nc.getConstraint() == null) {
                field.setConstraint(defaultfc.getConstraint());
                sb = sb.append("DC:");
            } else {
                field.setConstraint(nc.getConstraint());
                sb = sb.append("NC:");
            }
        }
        sb = sb.append("Constraint=" + field.getConstraint() + " ");
        if (field.getFieldTemplate() == null) {
            if (nc == null || nc.getFieldTemplate() == null) {
                field.setFieldTemplate(defaultfc.getFieldTemplate());
                sb = sb.append("DC:");
            } else {
                field.setFieldTemplate(nc.getFieldTemplate());
                sb = sb.append("NC:");
            }
        }
        sb = sb.append("FieldTemplate=" + field.getFieldTemplate() + " ");
        if (field.getNodeTransformer() == null) {
            if (nc == null || nc.getNodeTransformer() == null) {
                field.setNodeTransformer(defaultfc.getNodeTransformer());
                sb = sb.append("DC:");
            } else {
                field.setNodeTransformer(nc.getNodeTransformer());
                sb = sb.append("NC:");
            }
        }
        sb = sb.append("NodeTransformer=" + (field.getNodeTransformer() == null ? "" : field.getNodeTransformer().getName()) + " ");
        if (field.getWeight() == null) {
            if (nc == null || nc.getWeight() == null) {
                field.setWeight(defaultfc.getWeight());
                sb = sb.append("DC:");
            } else {
                field.setWeight(nc.getWeight());
                sb = sb.append("NC:");
            }
        }
        sb = sb.append("Weight=" + field.getWeight() + " ");
        if (field instanceof DTextField) {
            ITFParameter tfp;
            DTextField tf = (DTextField)field;
            if (nc != null) {
                tfp = ((org.eclipse.smila.search.datadictionary.messages.ddconfig.DTextField)nc).getParameter();
                this.insertTextParameter(tf, tfp, "NC", sb);
            }
            tfp = ((org.eclipse.smila.search.datadictionary.messages.ddconfig.DTextField)defaultfc).getParameter();
            this.insertTextParameter(tf, tfp, "DC", sb);
            if (tf.getParameter() != null) {
                tf.setParameter((ITFParameter)tf.getParameter().clone());
            }
        } else if (field instanceof DNumberField) {
            INFParameter nfp;
            DNumberField nf = (DNumberField)field;
            if (nc != null) {
                nfp = ((org.eclipse.smila.search.datadictionary.messages.ddconfig.DNumberField)nc).getParameter();
                this.insertNumberParameter(nf, nfp, "NC", sb);
            }
            nfp = ((org.eclipse.smila.search.datadictionary.messages.ddconfig.DNumberField)defaultfc).getParameter();
            this.insertNumberParameter(nf, nfp, "DC", sb);
            if (nf.getParameter() != null) {
                nf.setParameter((INFParameter)nf.getParameter().clone());
            }
        } else if (field instanceof org.eclipse.smila.search.utils.search.DDateField) {
            IDFParameter dfp;
            org.eclipse.smila.search.utils.search.DDateField df = (org.eclipse.smila.search.utils.search.DDateField)field;
            if (nc != null) {
                dfp = ((DDateField)nc).getParameter();
                this.insertDateParameter(df, dfp, "NC", sb);
            }
            dfp = ((DDateField)defaultfc).getParameter();
            this.insertDateParameter(df, dfp, "DC", sb);
            if (df.getParameter() != null) {
                df.setParameter((IDFParameter)df.getParameter().clone());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sb.toString());
        }
    }

    public abstract void unlock() throws IndexException;
}

