/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.templates;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.search.index.IndexConnection;
import org.eclipse.smila.search.templates.NodeTransformer;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.templates.NodeTransformerType;
import org.eclipse.smila.search.templates.messages.nodetransformerregistry.DNodeTransformer;
import org.eclipse.smila.search.templates.messages.nodetransformerregistry.DNodeTransformerRegistry;
import org.eclipse.smila.search.utils.param.ParameterSet;
import org.eclipse.smila.search.utils.param.set.DParameterSet;

public abstract class NodeTransformerRegistryController {
    private NodeTransformerRegistryController() {
    }

    public static NodeTransformer getNodeTransformer(String urn, IndexConnection ic) throws NodeTransformerException {
        Log log = LogFactory.getLog(NodeTransformerRegistryController.class);
        if (urn == null || urn.equals("")) {
            urn = "urn:SimpleNodeTransformer";
        }
        try {
            NodeTransformerType nodeTransformerType = NodeTransformerType.getTypes().get(urn);
            if (nodeTransformerType == null) {
                throw new NodeTransformerException("node transformer not found [" + urn + "]");
            }
            NodeTransformer nodeTransformer = nodeTransformerType.loadNodeTransformer();
            nodeTransformer.setIndexConnection(ic);
            return nodeTransformer;
        }
        catch (NodeTransformerException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("unable to instanciate node transformer [" + urn + "]"), (Throwable)e);
            throw new NodeTransformerException("unable to instanciate node transformer [" + urn + "]", e);
        }
    }

    public static NodeTransformer getNodeTransformer(org.eclipse.smila.search.utils.search.parameterobjects.DNodeTransformer dNodeTransformer, IndexConnection ic) throws NodeTransformerException {
        Log log = LogFactory.getLog(NodeTransformerRegistryController.class);
        if (dNodeTransformer == null) {
            return NodeTransformerRegistryController.getNodeTransformer("urn:SimpleNodeTransformer", ic);
        }
        try {
            NodeTransformerType nodeTransformerType = NodeTransformerType.getTypes().get(dNodeTransformer.getName());
            if (nodeTransformerType == null) {
                throw new NodeTransformerException("node transformer not found [" + dNodeTransformer.getName() + "]");
            }
            NodeTransformer nodeTransformer = nodeTransformerType.loadNodeTransformer();
            DParameterSet dParameterSet = dNodeTransformer.getParameterSet();
            if (dParameterSet != null) {
                ParameterSet paramSet = new ParameterSet(dParameterSet, nodeTransformerType.getParameterDefinition());
                nodeTransformer.setParameterSet(paramSet);
            }
            nodeTransformer.setIndexConnection(ic);
            return nodeTransformer;
        }
        catch (NodeTransformerException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("unable to instanciate node transformer [" + dNodeTransformer.getName() + "]"), (Throwable)e);
            throw new NodeTransformerException("unable to instanciate node transformer [" + dNodeTransformer.getName() + "]", e);
        }
    }

    public static DNodeTransformerRegistry getNodeTransformer() {
        Log log = LogFactory.getLog(NodeTransformerRegistryController.class);
        Hashtable<String, NodeTransformerType> nodeTransformers = NodeTransformerType.getTypes();
        DNodeTransformerRegistry registry = new DNodeTransformerRegistry();
        for (NodeTransformerType nodeTransformerType : nodeTransformers.values()) {
            DNodeTransformer nt;
            block3: {
                nt = new DNodeTransformer();
                nt.setClassName(nodeTransformerType.getClass().getName());
                nt.setDescription(nodeTransformerType.getName());
                nt.setName(nodeTransformerType.getName());
                try {
                    nt.setParameterDefinition(nodeTransformerType.getParameterDefinition());
                }
                catch (NodeTransformerException exception) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)exception);
                }
            }
            registry.addNodeTransformer(nt);
        }
        return registry;
    }
}

