/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.listener;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.smila.connectivity.queue.worker.Listener;
import org.eclipse.smila.connectivity.queue.worker.ListenerException;
import org.eclipse.smila.connectivity.queue.worker.ListenerRule;
import org.eclipse.smila.connectivity.queue.worker.config.ListenerConfigType;
import org.eclipse.smila.connectivity.queue.worker.config.ListenerRuleType;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractQueueService;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.connectivity.queue.worker.internal.listener.ListenerRuleImpl;

public class ListenerImpl
extends AbstractQueueService<ListenerConfigType>
implements Listener {
    private ListenerRuleImpl[] _rules;

    public ListenerImpl() {
        super("Listener");
    }

    @Override
    public String getConfigName() {
        return "QueueWorkerListenerConfig.xml";
    }

    @Override
    public synchronized void start() {
        this._log.info((Object)this.msg("Starting..."));
        ArrayList<ListenerRuleImpl> rules = new ArrayList<ListenerRuleImpl>();
        try {
            super.start();
            HashSet<String> names = new HashSet<String>();
            for (ListenerRuleType ruleConfig : ((ListenerConfigType)this._config).getRule()) {
                if (names.contains(ruleConfig.getName())) {
                    throw new ListenerException(String.format("Wrong configuration: rule name %s is not unique", ruleConfig.getName()));
                }
                names.add(ruleConfig.getName());
                rules.add(new ListenerRuleImpl((ServicesAccessPoint)this, ruleConfig));
            }
            this._rules = rules.toArray(new ListenerRuleImpl[rules.size()]);
            this._log.info((Object)this.msg(String.format("Started successfully, found %d rules", rules.size())));
        }
        catch (Throwable e) {
            this._log.error((Object)this.msg("Error starting"), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stop() {
        ListenerRuleImpl[] listenerRuleImplArray = this._rules;
        int n = this._rules.length;
        int n2 = 0;
        while (n2 < n) {
            ListenerRuleImpl rule = listenerRuleImplArray[n2];
            rule.stop();
            ++n2;
        }
        super.stop();
    }

    public ListenerRule[] getRules() {
        return this._rules;
    }
}

