/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.digest;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestHelper {
    private static final int BYTE_MASK = 255;

    private DigestHelper() {
    }

    public static String calculateDigest(byte[] bytes) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Cannot happen, SHA-256 MUST be available!");
        }
        byte[] hash = digest.digest(bytes);
        StringBuilder hexHash = new StringBuilder();
        int i = 0;
        while (i < hash.length) {
            hexHash.append(Integer.toHexString(hash[i] & 0xFF));
            ++i;
        }
        return hexHash.toString();
    }

    public static String calculateDigest(String value) {
        byte[] bytes;
        if (value == null) {
            return null;
        }
        try {
            bytes = value.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Cannot happen, utf-8 is always known!");
        }
        return DigestHelper.calculateDigest(bytes);
    }
}

