/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.smila.http.server.HttpExchange;

public class HttpExchangeImpl
implements HttpExchange {
    private final Request _req;
    private final HttpServletResponse _resp;
    private final String _host;
    private final int _port;

    public HttpExchangeImpl(Request req, HttpServletResponse resp, String host, int port) {
        this._req = req;
        this._resp = resp;
        this._host = host;
        this._port = port;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public String getProtocol() {
        return this._req.getProtocol();
    }

    @Override
    public String getRequestMethod() {
        return this._req.getMethod();
    }

    @Override
    public String getRequestHeader(String name) {
        return this._req.getHeader(name);
    }

    @Override
    public int getRequestIntHeader(String name) {
        return this._req.getIntHeader(name);
    }

    @Override
    public Enumeration<String> getRequestHeaders() {
        return this._req.getHeaderNames();
    }

    @Override
    public String getRequestURI() {
        return this._req.getRequestURI();
    }

    @Override
    public String getCompletePath() {
        return this._req.getUri().getCompletePath();
    }

    @Override
    public String getCharacterEncoding() {
        return this._req.getCharacterEncoding();
    }

    @Override
    public String getQueryString() {
        return this._req.getQueryString();
    }

    @Override
    public String getQueryParameter(String name) {
        return this._req.getParameter(name);
    }

    @Override
    public InputStream getRequestStream() throws IOException {
        return this._req.getInputStream();
    }

    @Override
    public void setResponseStatus(int sc) {
        this._resp.setStatus(sc);
    }

    @Override
    public void setResponseHeader(String name, String value) {
        this._resp.setHeader(name, value);
    }

    @Override
    public void setResponseIntHeader(String name, int value) {
        this._resp.setIntHeader(name, value);
    }

    @Override
    public OutputStream getResponseStream() throws IOException {
        return this._resp.getOutputStream();
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return this._req.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        return this._req.getParameterValues(name);
    }
}

