/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.eclipse.smila.http.server.HttpHandler;
import org.eclipse.smila.http.server.HttpService;
import org.eclipse.smila.http.server.JettyHandler;
import org.eclipse.smila.http.server.internal.HttpServer;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class HttpServiceImpl
implements HttpService {
    public static final String CONFIG_FILE = "jetty.xml";
    private final Log _log = LogFactory.getLog(HttpServiceImpl.class);
    private XmlConfiguration _configuration;
    private HttpServer _server;
    private final ArrayList<HttpHandler> _handlers = new ArrayList();
    private final ArrayList<JettyHandler> _jettyHandlers = new ArrayList();

    public void addHttpHandler(HttpHandler handler) {
        this._handlers.add(handler);
    }

    public void removeHttpHandler(HttpHandler handler) {
        if (this._handlers.contains(handler)) {
            this._handlers.remove(handler);
        }
    }

    public void addJettyHandler(JettyHandler handler) {
        this._jettyHandlers.add(handler);
    }

    public void removeJettyHandler(JettyHandler handler) {
        if (this._jettyHandlers.contains(handler)) {
            this._jettyHandlers.remove(handler);
        }
    }

    protected void activate(ComponentContext context) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                this.readConfiguration();
                this._server = new HttpServer(this._configuration);
                this.addContexts();
                this._server.start();
                System.out.println("HTTP server started successfully on port " + this._server.getPort() + ".");
            }
            catch (Exception ex) {
                String msg = "Starting HTTP server failed: " + ex.toString() + ". See log for details.";
                System.out.println(msg);
                this._log.error((Object)msg, (Throwable)ex);
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this._server != null) {
            try {
                this._server.stop();
                System.out.println("HTTP server stopped successfully.");
            }
            catch (Exception e) {
                this._log.error((Object)"Stopping HTTP server failed", (Throwable)e);
            }
        }
    }

    private void addContexts() {
        String message;
        for (HttpHandler httpHandler : this._handlers) {
            this._server.addHttpHandler(httpHandler);
            message = "HTTP server has SMILA handler " + httpHandler.getClass().getName() + " for context " + httpHandler.getRootContextPath() + ".";
            System.out.println(message);
        }
        for (JettyHandler jettyHandler : this._jettyHandlers) {
            this._server.addJettyHandler(jettyHandler);
            message = "HTTP server has Jetty handler " + jettyHandler.getClass().getName() + " for context " + jettyHandler.getRootContextPath() + ".";
            System.out.println(message);
        }
    }

    private void readConfiguration() throws IOException {
        InputStream configFileStream = null;
        try {
            try {
                configFileStream = ConfigUtils.getConfigStream((String)"org.eclipse.smila.http.server", (String)CONFIG_FILE);
                this._configuration = new XmlConfiguration(configFileStream);
            }
            catch (Exception ex) {
                throw new IOException("Reading properties from jetty.xml failed: " + ex.toString());
            }
        }
        finally {
            if (configFileStream != null) {
                IOUtils.closeQuietly((InputStream)configFileStream);
            }
        }
    }
}

