/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.intercept;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.intercept.FailMessageExchangeException;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.intercept.NoOpInterceptor;
import org.w3c.dom.Text;

public class ThrottlingInterceptor
extends NoOpInterceptor {
    private static final QName PROP_MAX_INSTANCES = new QName("urn:org.apache.ode.bpel.intercept", "maxInstances");

    public void onNewInstanceInvoked(MessageExchangeInterceptor.InterceptorEvent interceptorEvent) throws FailMessageExchangeException {
        int n;
        try {
            n = Integer.valueOf(this.getSimpleProperty(PROP_MAX_INSTANCES, interceptorEvent));
        }
        catch (Exception exception) {
            return;
        }
        if (interceptorEvent.getProcessDAO().getNumInstances() >= n) {
            throw new FailMessageExchangeException("Too many instances.");
        }
    }

    private String getSimpleProperty(QName qName, MessageExchangeInterceptor.InterceptorEvent interceptorEvent) {
        Map map = interceptorEvent.getProcessConf().getProcessProperties();
        for (Map.Entry entry : map.entrySet()) {
            if (!((QName)entry.getKey()).equals(qName)) continue;
            return ((Text)entry.getValue()).getWholeText();
        }
        return null;
    }
}

