/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.processing.pipelets.ATransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XMLUtils;
import org.w3c.dom.Document;

public abstract class AXmlTransformationPipelet
extends ATransformationPipelet {
    protected Document createDocument(Blackboard blackboard, String id) throws Exception {
        Document inputDocument = null;
        if (this.isReadFromAttribute()) {
            String value = blackboard.getMetadata(id).getStringValue(this._inputName);
            if (value != null) {
                inputDocument = XMLUtils.parse(value.getBytes("utf-8"), false);
            }
        } else {
            byte[] value = blackboard.getAttachment(id, this._inputName);
            inputDocument = XMLUtils.parse(value, false);
        }
        return inputDocument;
    }

    protected void storeDocument(Blackboard blackboard, String id, Document doc) throws Exception {
        if (this.isStoreInAttribute()) {
            String domString = XMLUtils.documentToString(doc);
            blackboard.getMetadata(id).put(this._outputName, domString);
        } else {
            byte[] attachment = XMLUtils.documentToBytes(doc);
            blackboard.setAttachment(id, this._outputName, attachment);
        }
    }
}

