/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XslTransformer;
import org.w3c.dom.Document;

public class XslTransformationPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_XSL_FILE = "xslFile";
    private String _xslFile;
    private XslTransformer _xslTransformer;

    public void configure(AnyMap configuration) throws ProcessingException {
        super.configure(configuration);
        this._xslFile = configuration.getStringValue(PROP_XSL_FILE);
        if (this._xslFile == null || this._xslFile.trim().length() == 0) {
            throw new ProcessingException("Property xslFile must not be <null> or an empty String");
        }
        this._xslTransformer = new XslTransformer();
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    String id = stringArray[n2];
                    try {
                        Document inputDocument = this.createDocument(blackboard, id);
                        if (inputDocument != null) {
                            Document result = this._xslTransformer.transform(inputDocument, this._xslFile);
                            this.storeDocument(blackboard, id, result);
                        }
                    }
                    catch (Exception e) {
                        if (!this._log.isWarnEnabled()) break block5;
                        this._log.warn((Object)("unable to transform document " + id), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

