/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetHeaderProcessor
extends DelegateProcessor
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(SetHeaderProcessor.class);
    private String name;
    private Expression expression;

    public SetHeaderProcessor(String name, Expression expression) {
        this.name = name;
        this.expression = expression;
    }

    public SetHeaderProcessor(String name, Expression expression, Processor childProcessor) {
        super(childProcessor);
        this.name = name;
        this.expression = expression;
    }

    public void process(Exchange exchange) throws Exception {
        Object value = this.expression.evaluate(exchange);
        if (value == null) {
            LOG.warn((Object)("Expression: " + this.expression + " on exchange: " + exchange + " evaluated to null."));
        }
        exchange.getIn().setHeader(this.name, value);
        super.process(exchange);
    }

    public String toString() {
        return "setHeader(" + this.name + ", " + this.expression + ")";
    }
}

