/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMUtils {
    public static Element toDOM(OMElement oMElement) {
        return OMUtils.toDOM(oMElement, DOMUtils.newDocument());
    }

    public static Element toDOM(OMElement oMElement, Document document) {
        return OMUtils.toDOM(oMElement, document, true);
    }

    public static Element toDOM(OMElement oMElement, Document document, boolean bl) {
        OMNamespace oMNamespace;
        Object object;
        Element element = document.createElementNS(oMElement.getQName().getNamespaceURI(), oMElement.getQName().getLocalPart());
        if (bl) {
            object = new NSContext();
            OMUtils.buildNScontext((NSContext)object, oMElement);
            DOMUtils.injectNamespaces((Element)element, (NSContext)object);
        } else if (oMElement.getAllDeclaredNamespaces() != null) {
            object = oMElement.getAllDeclaredNamespaces();
            while (object.hasNext()) {
                oMNamespace = (OMNamespace)object.next();
                if (oMNamespace.getPrefix().equals("")) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", oMNamespace.getNamespaceURI() == null ? "" : oMNamespace.getNamespaceURI());
                    continue;
                }
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + oMNamespace.getPrefix(), oMNamespace.getNamespaceURI());
            }
        }
        object = oMElement.getAllAttributes();
        while (object.hasNext()) {
            OMNamespace oMNamespace2;
            oMNamespace = (OMAttribute)object.next();
            Attr attr = oMNamespace.getNamespace() != null ? document.createAttributeNS(oMNamespace.getNamespace().getNamespaceURI(), oMNamespace.getLocalName()) : document.createAttributeNS(null, oMNamespace.getLocalName());
            attr.appendChild(document.createTextNode(oMNamespace.getAttributeValue()));
            element.setAttributeNodeNS(attr);
            int n = oMNamespace.getAttributeValue().indexOf(":");
            if (n <= 0 || (oMNamespace2 = oMElement.findNamespaceURI(oMNamespace.getAttributeValue().substring(0, n))) == null) continue;
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + oMNamespace2.getPrefix(), oMNamespace2.getNamespaceURI());
        }
        object = oMElement.getChildren();
        while (object.hasNext()) {
            oMNamespace = (OMNode)object.next();
            switch (oMNamespace.getType()) {
                case 12: {
                    element.appendChild(document.createCDATASection(((OMText)oMNamespace).getText()));
                    break;
                }
                case 4: {
                    element.appendChild(document.createTextNode(((OMText)oMNamespace).getText()));
                    break;
                }
                case 1: {
                    element.appendChild(OMUtils.toDOM((OMElement)oMNamespace, document, false));
                }
            }
        }
        return element;
    }

    private static void buildNScontext(NSContext nSContext, OMElement oMElement) {
        if (oMElement == null) {
            return;
        }
        if (oMElement.getParent() instanceof OMElement) {
            OMUtils.buildNScontext(nSContext, (OMElement)oMElement.getParent());
        }
        if (oMElement.getAllDeclaredNamespaces() != null) {
            Iterator iterator = oMElement.getAllDeclaredNamespaces();
            while (iterator.hasNext()) {
                OMNamespace oMNamespace = (OMNamespace)iterator.next();
                nSContext.register(oMNamespace.getPrefix(), oMNamespace.getNamespaceURI());
            }
        }
        if (oMElement.getDefaultNamespace() != null) {
            nSContext.register("", oMElement.getDefaultNamespace().getNamespaceURI());
        }
    }

    public static OMElement toOM(Element element, OMFactory oMFactory) {
        return OMUtils.toOM(element, oMFactory, null);
    }

    public static OMElement toOM(Element element, OMFactory oMFactory, OMContainer oMContainer) {
        Node node;
        Object object;
        OMElement oMElement;
        OMElement oMElement2 = oMElement = oMContainer == null ? oMFactory.createOMElement(element.getLocalName(), null) : oMFactory.createOMElement(element.getLocalName(), null, oMContainer);
        if (element.getNamespaceURI() != null) {
            if (element.getPrefix() != null) {
                oMElement.setNamespace(oMFactory.createOMNamespace(element.getNamespaceURI(), element.getPrefix()));
            } else {
                oMElement.declareDefaultNamespace(element.getNamespaceURI());
            }
        }
        if (oMContainer == null) {
            object = DOMUtils.getMyNSContext((Element)element);
            OMUtils.injectNamespaces(oMElement, object.toMap());
        } else {
            object = DOMUtils.getMyNamespaces((Element)element);
            OMUtils.injectNamespaces(oMElement, (Map<String, String>)object);
        }
        object = element.getAttributes();
        for (int i = 0; i < object.getLength(); ++i) {
            Attr attr = (Attr)object.item(i);
            if (attr.getLocalName().equals("xmlns") || attr.getNamespaceURI() != null && attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            node = null;
            String string = attr.getNamespaceURI();
            String string2 = attr.getPrefix();
            if (string != null) {
                node = oMElement.findNamespace(string, null);
            }
            if (node == null && string2 != null) {
                node = oMElement.findNamespace(null, string2);
            }
            oMElement.addAttribute(attr.getLocalName(), attr.getValue(), (OMNamespace)node);
        }
        NodeList nodeList = element.getChildNodes();
        block6: for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    oMElement.addChild((OMNode)oMFactory.createOMText(((CDATASection)node).getTextContent(), 12));
                    continue block6;
                }
                case 3: {
                    oMElement.addChild((OMNode)oMFactory.createOMText(((Text)node).getTextContent(), 4));
                    continue block6;
                }
                case 1: {
                    OMUtils.toOM((Element)node, oMFactory, (OMContainer)oMElement);
                }
            }
        }
        return oMElement;
    }

    private static void injectNamespaces(OMElement oMElement, Map<String, String> map) {
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            if (string.equals("")) {
                oMElement.declareDefaultNamespace(string2);
                continue;
            }
            oMElement.declareNamespace(string2, string);
        }
    }

    public static QName getTextAsQName(OMElement oMElement) {
        QName qName = oMElement.getTextAsQName();
        if (qName == null || qName.getNamespaceURI().length() == 0) {
            int n = oMElement.getText().indexOf(":");
            String string = oMElement.getText().substring(n + 1, oMElement.getText().length());
            String string2 = oMElement.getText().substring(0, n);
            String string3 = oMElement.findNamespaceURI(string2).getNamespaceURI();
            qName = new QName(string3, string, string2);
        }
        return qName;
    }

    public static OMElement toOM(Source source) throws IOException {
        Document document = DOMUtils.sourceToDOM((Source)source);
        return OMUtils.toOM(document.getDocumentElement(), OMAbstractFactory.getOMFactory());
    }

    public static void main(String[] stringArray) {
        OMFactory oMFactory = OMAbstractFactory.getOMFactory();
        OMNamespace oMNamespace = oMFactory.createOMNamespace("ns:foo:bar", null);
        OMElement oMElement = oMFactory.createOMElement("baz", null);
        oMElement.declareDefaultNamespace("ns:foo:bar");
        System.out.println(oMElement);
    }
}

