/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.extension.ExtensibleElement;
import org.apache.ode.bpel.rtrep.common.extension.ExtensionContext;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.xml.DOMRecordReader;
import org.eclipse.smila.ode.ODEServer;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.PipeletTrackerListener;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.BPELConstants;
import org.eclipse.smila.processing.bpel.MessageHelper;
import org.eclipse.smila.processing.bpel.ODEWorkflowProcessor;
import org.eclipse.smila.processing.bpel.PipeletHolder;
import org.eclipse.smila.processing.bpel.PipeletPerformanceCounter;
import org.eclipse.smila.processing.bpel.ProcessingPerformanceCounter;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PipeletManager
implements PipeletTrackerListener {
    private static final PipeletManager INSTANCE = new PipeletManager();
    private final Map<String, Class<? extends Pipelet>> _activePipeletClasses = new HashMap<String, Class<? extends Pipelet>>();
    private final Map<QName, ODEWorkflowProcessor> _ownerMap = new HashMap<QName, ODEWorkflowProcessor>();
    private final Map<String, PipeletHolder> _pipeletHolderMap = new HashMap<String, PipeletHolder>();
    private final DOMRecordReader _configReader = new DOMRecordReader();
    private final Log _log = LogFactory.getLog(this.getClass());

    private PipeletManager() {
    }

    public static PipeletManager getInstance() {
        return INSTANCE;
    }

    public void registerAsListener(BundleContext context) {
        Hashtable properties = new Hashtable();
        context.registerService(PipeletTrackerListener.class.getName(), (Object)this, properties);
    }

    public PipeletHolder doRegisterActivity(OProcess pipelineProcess, OExtensionActivity activity, Element content, String key) {
        PipeletHolder instance = new PipeletHolder();
        instance.setClassName(this.getAttributeOfElement(content, "pipelet", "class"));
        if (instance.getClassName() == null) {
            throw new CompilationException(this.createErrorCompilationMessage(key, "Missing definition of pipelet class"));
        }
        instance.setConfiguration(this.parseConfiguration(content));
        if (instance.getConfiguration() == null) {
            this._log.info((Object)(String.valueOf(key) + ": no pipelet configuration found."));
        } else {
            this._log.info((Object)(String.valueOf(key) + ": pipelet configuration parsed."));
        }
        String location = activity.name;
        instance.setCounter(new PipeletPerformanceCounter(pipelineProcess.getName(), instance.getClassName(), location));
        try {
            this.initPipeletInstance(instance);
        }
        catch (ProcessingException ex) {
            throw new CompilationException(this.createErrorCompilationMessage(key, "error initialising pipelet"), (Throwable)ex);
        }
        return instance;
    }

    public void checkAvailability(PipeletHolder pipeletHolder, ODEWorkflowProcessor processor) throws ProcessingException {
        Pipelet pipelet = pipeletHolder.getPipelet();
        if (pipelet == null) {
            throw new ProcessingException("Pipelet of class " + pipeletHolder.getClassName() + " for activity " + pipeletHolder.getKey() + " is not yet instantiated.");
        }
    }

    public void invokeActivity(ExtensionContext context, Element element) {
        long startTime = System.nanoTime();
        ProcessingPerformanceCounter counter = null;
        boolean success = false;
        try {
            try {
                OActivity activity;
                String key;
                PipeletHolder pipeletHolder;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("activity name = " + context.getActivityName()));
                    this._log.debug((Object)("process id = " + context.getProcessId()));
                }
                if ((pipeletHolder = this._pipeletHolderMap.get(key = this.getActivityKey(activity = context.getOActivity()))) == null) {
                    throw new ProcessingException("no registration found for key: " + key);
                }
                ODEWorkflowProcessor processor = this.getProcessor(activity);
                counter = pipeletHolder.getCounter();
                this.invokePipelet(context, key, pipeletHolder, processor);
                context.complete();
                success = true;
            }
            catch (Exception ex) {
                if (counter != null) {
                    counter.addError(ex, false);
                }
                context.completeWithFault((Throwable)ex);
                if (counter != null) {
                    counter.countInvocationNanos(System.nanoTime() - startTime, success, 0, 0);
                }
            }
        }
        finally {
            if (counter != null) {
                counter.countInvocationNanos(System.nanoTime() - startTime, success, 0, 0);
            }
        }
    }

    private void invokePipelet(ExtensionContext context, String key, PipeletHolder pipeletHolder, ODEWorkflowProcessor processor) throws ProcessingException {
        String requestId = null;
        String inputVariableName = pipeletHolder.getInputVariable();
        String outputVariableName = pipeletHolder.getOutputVariable();
        if (outputVariableName == null) {
            outputVariableName = inputVariableName;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(String.valueOf(key) + ": invoking " + pipeletHolder.getPrintName() + ", processing " + inputVariableName + " -> " + outputVariableName));
        }
        ClassLoader tcclBackup = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ODEServer.class.getClassLoader());
        try {
            try {
                Element inputVariable = (Element)context.readVariable(inputVariableName);
                QName varType = this.getVariableType(context, inputVariableName);
                if (this._log.isDebugEnabled()) {
                    String inputVariableString = DOMUtils.domToString((Node)inputVariable);
                    this._log.debug((Object)(String.valueOf(key) + ": input = " + inputVariableString));
                }
                MessageHelper messageHelper = processor.getMessageHelper();
                requestId = messageHelper.parseRequestId(inputVariable);
                this.checkAvailability(pipeletHolder, processor);
                Blackboard blackboard = processor.getBlackboard(requestId);
                String[] request = messageHelper.parseMessage(blackboard, inputVariable);
                String[] result = this.doInvoke(pipeletHolder, processor, blackboard, request);
                Element outputVariable = messageHelper.createMessage(blackboard, result);
                messageHelper.addRequestId(outputVariable, requestId, varType);
                if (this._log.isDebugEnabled()) {
                    String outputVariableString = DOMUtils.domToString((Node)outputVariable);
                    this._log.debug((Object)(String.valueOf(key) + ": output = " + outputVariableString));
                }
                context.writeVariable(outputVariableName, (Node)outputVariable);
            }
            catch (ProcessingException ex) {
                throw this.newProcessingException("processing", (Exception)((Object)ex), key, requestId, processor);
            }
            catch (FaultException ex) {
                throw this.newProcessingException("BPEL variable access", (Exception)((Object)ex), key, requestId, processor);
            }
            catch (ExternalVariableModuleException ex) {
                throw this.newProcessingException("BPEL variable access", (Exception)((Object)ex), key, requestId, processor);
            }
            catch (RuntimeException ex) {
                throw this.newProcessingException("runtime", ex, key, requestId, processor);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcclBackup);
        }
    }

    private String[] doInvoke(PipeletHolder pipeletHolder, ODEWorkflowProcessor processor, Blackboard blackboard, String[] request) throws ProcessingException {
        int incomingIds = 0;
        int outgoingIds = 0;
        try {
            Pipelet pipelet = pipeletHolder.getPipelet();
            incomingIds = this.getRecordCount(request);
            String[] result = pipelet.process(blackboard, request);
            outgoingIds = this.getRecordCount(result);
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            if (pipeletHolder.getCounter() != null) {
                pipeletHolder.getCounter().countIds(incomingIds, outgoingIds);
            }
        }
    }

    public void registerPipeline(ODEWorkflowProcessor processor, QName processName) {
        this._ownerMap.put(processName, processor);
    }

    public void registerActivity(OExtensionActivity activity, ExtensibleElement element) {
        OProcess process = activity.getOwner();
        String key = this.getActivityKey((OActivity)activity);
        Element content = element.getNestedElement();
        PipeletHolder pipeletHolder = this.doRegisterActivity(process, activity, content, key);
        if (pipeletHolder != null) {
            pipeletHolder.setKey(key);
            pipeletHolder.setInputVariable(this.getAttributeOfElement(content, "variables", "input"));
            pipeletHolder.setOutputVariable(this.getAttributeOfElement(content, "variables", "output"));
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)(String.valueOf(key) + ": found " + pipeletHolder.getPrintName() + ", processing " + pipeletHolder.getInputVariable() + " -> " + pipeletHolder.getOutputVariable()));
            }
            this._pipeletHolderMap.put(key, pipeletHolder);
        }
    }

    public void pipeletsAdded(Map<String, Class<? extends Pipelet>> pipeletClasses) {
        this._log.info((Object)("Pipelets have been added: " + pipeletClasses.keySet()));
        this._activePipeletClasses.putAll(pipeletClasses);
        for (PipeletHolder holder : this._pipeletHolderMap.values()) {
            try {
                this.initPipeletInstance(holder);
            }
            catch (ProcessingException ex) {
                this._log.error((Object)"error when initializing pending pipelet", (Throwable)ex);
            }
        }
    }

    public void pipeletsRemoved(Map<String, Class<? extends Pipelet>> pipeletClasses) {
        this._log.info((Object)("Pipelets have been removed: " + pipeletClasses.keySet()));
        for (PipeletHolder holder : this._pipeletHolderMap.values()) {
            if (!pipeletClasses.containsKey(holder.getClassName())) continue;
            holder.setPipelet(null);
        }
        for (String className : pipeletClasses.keySet()) {
            this._activePipeletClasses.remove(className);
        }
    }

    private void initPipeletInstance(PipeletHolder instance) throws ProcessingException {
        String className;
        if (instance.getPipelet() == null && this._activePipeletClasses.containsKey(className = instance.getClassName())) {
            Class<? extends Pipelet> pipeletClass = this._activePipeletClasses.get(className);
            try {
                Pipelet pipelet = pipeletClass.newInstance();
                if (instance.getConfiguration() != null) {
                    ClassLoader tcclBackup = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(ODEServer.class.getClassLoader());
                    try {
                        pipelet.configure(instance.getConfiguration());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(tcclBackup);
                    }
                }
                instance.setPipelet(pipelet);
            }
            catch (InstantiationException e) {
                throw new ProcessingException("error instantiating pipelet class " + className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ProcessingException("error instantiating pipelet class " + className, (Throwable)e);
            }
        }
    }

    private AnyMap parseConfiguration(Element content) {
        AnyMap configuration = null;
        NodeList config = content.getElementsByTagNameNS("http://www.eclipse.org/smila/processor", "configuration");
        if (config.getLength() > 0) {
            Element configElement = (Element)config.item(0);
            configuration = this._configReader.parseMap(configElement);
        }
        return configuration;
    }

    private String getAttributeOfElement(Element content, String localName, String attribute) {
        String attributeValue = null;
        NodeList nodes = content.getElementsByTagNameNS("http://www.eclipse.org/smila/processor", localName);
        if (nodes.getLength() > 0 && StringUtils.isBlank((String)(attributeValue = ((Element)nodes.item(0)).getAttribute(attribute)))) {
            attributeValue = null;
        }
        return attributeValue;
    }

    private CompilationMessage createErrorCompilationMessage(String key, String message) {
        CompilationMessage msg = new CompilationMessage();
        msg.severity = (short)2;
        msg.phase = 0;
        msg.code = key;
        msg.messageText = message;
        return msg;
    }

    private int getRecordCount(String[] recordIds) {
        if (recordIds != null) {
            return recordIds.length;
        }
        return 0;
    }

    private String getActivityKey(OActivity activity) {
        return String.valueOf(activity.getOwner().getName()) + "/" + activity.name;
    }

    private ODEWorkflowProcessor getProcessor(OActivity activity) throws ProcessingException {
        QName processName = activity.getOwner().getQName();
        ODEWorkflowProcessor processor = this._ownerMap.get(processName);
        if (processor == null) {
            throw new ProcessingException("no owning processor found for " + this.getActivityKey(activity));
        }
        return processor;
    }

    private QName getVariableType(ExtensionContext context, String variableName) {
        QName varType = BPELConstants.TYPE_PROCESSORMESSAGE;
        try {
            QName type;
            OScope.Variable variable = (OScope.Variable)context.getVisibleVariables().get(variableName);
            if (variable.type instanceof OMessageVarType && (type = ((OMessageVarType)variable.type).messageType) != null) {
                varType = type;
            }
        }
        catch (Exception exception) {
        }
        return varType;
    }

    private ProcessingException newProcessingException(String description, Exception cause, String key, String requestId, ODEWorkflowProcessor processor) {
        String message = null;
        ProcessingException procEx = null;
        if (cause instanceof ProcessingException) {
            message = "Invocation of pipeline element " + key + " failed: " + cause.getMessage();
            procEx = new ProcessingException(message, cause.getCause());
        } else {
            message = "Invocation of pipeline element " + key + " failed due to " + description + " error.";
            procEx = new ProcessingException(message, (Throwable)cause);
        }
        if (requestId != null) {
            processor.setPipeletException(requestId, (Exception)((Object)procEx));
        }
        return procEx;
    }
}

