/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.event;

import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.event.CamelEvent;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventEndpoint
extends DefaultEndpoint<Exchange>
implements ApplicationContextAware {
    private LoadBalancer loadBalancer;
    private ApplicationContext applicationContext;

    public EventEndpoint(String endpointUri, EventComponent component) {
        super(endpointUri, (Component)component);
        this.applicationContext = component.getApplicationContext();
    }

    public EventEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            public void process(Exchange exchange) throws Exception {
                ApplicationEvent event = EventEndpoint.this.toApplicationEvent(exchange);
                EventEndpoint.this.getApplicationContext().publishEvent(event);
            }
        };
    }

    public EventConsumer createConsumer(Processor processor) throws Exception {
        return new EventConsumer(this, processor);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody((Object)event);
        try {
            this.getLoadBalancer().process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public synchronized void consumerStarted(EventConsumer consumer) {
        this.getLoadBalancer().addProcessor(consumer.getProcessor());
    }

    public synchronized void consumerStopped(EventConsumer consumer) {
        this.getLoadBalancer().removeProcessor(consumer.getProcessor());
    }

    protected LoadBalancer createLoadBalancer() {
        return new TopicLoadBalancer();
    }

    protected ApplicationEvent toApplicationEvent(Exchange exchange) {
        ApplicationEvent event = (ApplicationEvent)exchange.getIn().getBody(ApplicationEvent.class);
        if (event == null) {
            event = new CamelEvent(this, exchange);
        }
        return event;
    }
}

