/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.blackboard.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.BinaryStorageService;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.impl.TransientBlackboardImpl;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.filter.RecordFilterHelper;
import org.eclipse.smila.recordstorage.RecordStorage;
import org.eclipse.smila.recordstorage.RecordStorageException;

public class PersistingBlackboardImpl
extends TransientBlackboardImpl {
    private final Log _log = LogFactory.getLog(this.getClass());
    private RecordStorage _recordStorage;
    private BinaryStorageService _binaryStorage;

    public PersistingBlackboardImpl(RecordFilterHelper filterHelper, File attachmentsTempDir) {
        super(filterHelper, attachmentsTempDir);
    }

    public void setRecordStorage(RecordStorage recordStorage) {
        this._recordStorage = recordStorage;
    }

    public void setBinaryStorage(BinaryStorageService binaryStorage) {
        this._binaryStorage = binaryStorage;
    }

    @Override
    public Record load(String id) throws BlackboardAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Record Id cannot be null");
        }
        Record record = this.getCachedRecord(id);
        if (record == null) {
            if (this._recordStorage == null) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)"RecordStorage is not bound - creating empty record");
                }
                return this.create(id);
            }
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Loading record by id: " + id));
                }
                if ((record = this._recordStorage.loadRecord(id)) != null) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Record loaded: " + record));
                    }
                    super.setRecord(record);
                } else if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("No record found with id: " + id));
                }
            }
            catch (RecordStorageException exception) {
                throw new BlackboardAccessException("Error loading record with id = " + id, exception);
            }
        }
        return record;
    }

    @Override
    public void setRecord(Record record) throws BlackboardAccessException {
        String id = record.getId();
        super.setRecord(record);
        Iterator attachmentNames = record.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            String attachmentName = (String)attachmentNames.next();
            byte[] attachment = record.getAttachment(attachmentName);
            if (attachment == null) continue;
            this.setAttachment(id, attachmentName, attachment);
        }
    }

    @Override
    public void commit(String id) throws BlackboardAccessException {
        Record record;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Committing record, IdHash=" + id));
        }
        if ((record = this.getCachedRecord(id)) == null) {
            throw new BlackboardAccessException("Record with id = " + id + " is not loaded in the blackboard.");
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Record to commit: " + record));
        }
        try {
            if (this._recordStorage == null) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)"RecordStorage is not bound - record won't be committed to RecordStorage");
                }
            } else {
                this._recordStorage.storeRecord(record);
            }
        }
        catch (RecordStorageException ex) {
            try {
                this.invalidate(id);
            }
            catch (Exception e) {
                this._log.error((Object)("Error invalidating record with id = " + id), (Throwable)e);
            }
            throw new BlackboardAccessException(ex);
        }
        super.commit(id);
    }

    @Override
    public void invalidate(String id) {
        try {
            try {
                if (this._recordStorage == null) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)"RecordStorage is not bound - invalidate won't remove attachments of the non-committed record.");
                    }
                } else if (!this._recordStorage.existsRecord(id)) {
                    this.removeCachedRecordAttachments(id);
                }
            }
            catch (RecordStorageException recordStorageException) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)"RecordStorage could not check existence of record - invalidate won't remove attachments of the non-committed record.");
                }
                super.invalidate(id);
            }
        }
        finally {
            super.invalidate(id);
        }
    }

    @Override
    public void removeRecord(String id) {
        Record record = this.getCachedRecord(id);
        if (record != null) {
            if (this._recordStorage != null) {
                try {
                    this._recordStorage.removeRecord(id);
                }
                catch (RecordStorageException ex) {
                    this._log.warn((Object)("Could not remove record " + id + " from record storage"), (Throwable)ex);
                }
            }
            if (this._binaryStorage != null && record.hasAttachments()) {
                Iterator names = record.getAttachmentNames();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    try {
                        this.removeAttachment(id, name);
                    }
                    catch (BlackboardAccessException ex) {
                        this._log.warn((Object)("Could not remove attachment " + name + " of record " + id + " from binary storage"), (Throwable)ex);
                    }
                }
            }
        }
        super.removeRecord(id);
    }

    @Override
    public byte[] getAttachment(String id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        if (!record.hasAttachment(name)) {
            throw new BlackboardAccessException("Record with id = " + id + " doesn't have the attachment [" + name + "]");
        }
        byte[] attachment = null;
        try {
            attachment = this._binaryStorage.fetchAsByte(this.getAttachmentId(id, name));
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Could not get the attachment-file from binary storage for record having id :" + id, bsex);
        }
        return attachment;
    }

    @Override
    public InputStream getAttachmentAsStream(String id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        if (!record.hasAttachment(name)) {
            throw new BlackboardAccessException("Record with id = " + id + " doesn't have the attachment [" + name + "]");
        }
        InputStream attachmentInputStream = null;
        try {
            attachmentInputStream = this._binaryStorage.fetchAsStream(this.getAttachmentId(id, name));
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Could not get the attachment-file from binary storage for record having id :" + id, bsex);
        }
        return attachmentInputStream;
    }

    @Override
    public void setAttachment(String id, String name, byte[] attachment) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        this.storeAttachment(id, name, attachment);
        this.checkCachedFileAttachment(id, name);
        record.setAttachment(name, null);
    }

    @Override
    public void setAttachmentFromStream(String id, String name, InputStream attachmentStream) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        this.storeAttachment(id, name, attachmentStream);
        this.checkCachedFileAttachment(id, name);
        record.setAttachment(name, null);
    }

    @Override
    public void setAttachmentFromFile(String id, String name, File attachmentFile) throws BlackboardAccessException {
        FileInputStream attachmentStream = null;
        try {
            try {
                Record record = this.getRecord(id);
                attachmentStream = FileUtils.openInputStream((File)attachmentFile);
                this.storeAttachment(id, name, attachmentFile);
                this.checkCachedFileAttachment(id, name);
                record.setAttachment(name, null);
            }
            catch (IOException exception) {
                throw new BlackboardAccessException(exception);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(attachmentStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)attachmentStream);
    }

    @Override
    public void removeAttachment(String id, String name) throws BlackboardAccessException {
        try {
            try {
                String attachmentId = this.getAttachmentId(id, name);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Removing attachment " + attachmentId + " from binary storage"));
                }
                this._binaryStorage.remove(attachmentId);
            }
            catch (BinaryStorageException bsex) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)("Failed to remove attachment " + name + " from binary storage for record having id :" + id + " - " + bsex.getMessage()));
                }
                throw new BlackboardAccessException(bsex);
            }
        }
        finally {
            super.removeAttachment(id, name);
        }
    }

    private void storeAttachment(String id, String name, InputStream attachment) throws BlackboardAccessException {
        String attachmentId = this.getAttachmentId(id, name);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Saving attachment " + attachmentId + " to binary storage"));
        }
        try {
            this._binaryStorage.store(attachmentId, attachment);
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Failed to save attachment in binary storage for record having id :" + id, bsex);
        }
    }

    private void storeAttachment(String id, String name, byte[] attachment) throws BlackboardAccessException {
        String attachmentId = this.getAttachmentId(id, name);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Saving attachment " + attachmentId + " to binary storage"));
        }
        try {
            this._binaryStorage.store(attachmentId, attachment);
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Failed to save attachment in binary storage for record having id :" + id, bsex);
        }
    }

    private void storeAttachment(String id, String name, File attachment) throws BlackboardAccessException {
        String attachmentId = this.getAttachmentId(id, name);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Saving attachment " + attachmentId + " to binary storage"));
        }
        FileInputStream attachmentStream = null;
        try {
            try {
                attachmentStream = FileUtils.openInputStream((File)attachment);
                this._binaryStorage.store(attachmentId, (InputStream)attachmentStream);
            }
            catch (Exception exception) {
                throw new BlackboardAccessException("Failed to save attachment in binary storage for record having id :" + id, exception);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)attachmentStream);
        }
    }

    private void removeCachedRecordAttachments(String id) {
        Record record = this.getCachedRecord(id);
        if (record != null) {
            if (record.hasAttachments()) {
                Iterator attachmentNames = record.getAttachmentNames();
                while (attachmentNames.hasNext()) {
                    String attachmentName = (String)attachmentNames.next();
                    try {
                        this._binaryStorage.remove(this.getAttachmentId(id, attachmentName));
                    }
                    catch (BinaryStorageException storageException) {
                        if (!this._log.isErrorEnabled()) continue;
                        this._log.error((Object)("Could not invalidate/delete the attachment-file from binary storage for record having id :" + id + " - " + storageException.getMessage()));
                    }
                }
            }
        } else if (this._log.isWarnEnabled()) {
            this._log.warn((Object)("Record with id = " + id + " is not loaded in the blackboard."));
        }
    }
}

