/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.blackboard.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.filter.RecordFilterHelper;
import org.eclipse.smila.datamodel.filter.RecordFilterNotFoundException;
import org.eclipse.smila.utils.digest.DigestHelper;

public class TransientBlackboardImpl
implements Blackboard {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Map<String, Record> _recordMap = new HashMap<String, Record>();
    private final Map<String, Map<String, File>> _attachmentMap = new HashMap<String, Map<String, File>>();
    private final Map<String, Serializable> _globalNotes = new HashMap<String, Serializable>();
    private final Map<String, Map<String, Serializable>> _recordNotesMap = new HashMap<String, Map<String, Serializable>>();
    private final RecordFilterHelper _filterHelper;
    private final File _attachmentsTempDir;
    private final DataFactory _dataFactory = DataFactoryCreator.createDefaultFactory();

    public TransientBlackboardImpl(RecordFilterHelper filterHelper, File attachmentsTempDir) {
        this._filterHelper = filterHelper;
        this._attachmentsTempDir = attachmentsTempDir;
    }

    @Override
    public DataFactory getDataFactory() {
        return this._dataFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record getRecord(String id) throws BlackboardAccessException {
        Map<String, Record> map = this._recordMap;
        synchronized (map) {
            Record record = this._recordMap.get(id);
            if (record != null) {
                return record;
            }
            this.load(id);
            return this._recordMap.get(id);
        }
    }

    @Override
    public AnyMap getMetadata(String id) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        if (record != null) {
            return record.getMetadata();
        }
        return null;
    }

    @Override
    public Record getRecord(String id, String filterName) throws RecordFilterNotFoundException, BlackboardAccessException {
        Record record = this.getRecord(id);
        return this.filterRecord(record, filterName);
    }

    @Override
    public Record filterRecord(Record record, String filterName) throws RecordFilterNotFoundException {
        Record newRecord = null;
        if (record != null) {
            newRecord = this._filterHelper.filter(record, filterName);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("RECORD BEFORE FILTERING:" + record));
                this._log.debug((Object)("RECORD AFTER  FILTERING:" + newRecord));
            }
        }
        return newRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecord(Record record) throws BlackboardAccessException {
        String id = record.getId();
        Map<String, Record> map = this._recordMap;
        synchronized (map) {
            this._recordMap.put(id, record);
        }
    }

    @Override
    public Record copyRecord(String id, String newId) throws BlackboardAccessException {
        Record record = this._recordMap.get(id);
        Record copyRecord = this._dataFactory.createRecord();
        copyRecord.getMetadata().putAll((Map)this._dataFactory.cloneAnyMap(record.getMetadata()));
        copyRecord.setId(newId);
        this._recordMap.put(newId, copyRecord);
        if (this._recordNotesMap.containsKey(id)) {
            this._recordNotesMap.put(newId, this._recordNotesMap.get(id));
        }
        return copyRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeRecord(Record record) throws BlackboardAccessException {
        if (record == null) {
            throw new IllegalArgumentException("record must not be null!");
        }
        if (record.getId() == null) {
            throw new IllegalArgumentException("record.id must not be null!");
        }
        if (record.getMetadata() == null) {
            throw new IllegalArgumentException("record.metadata must not be null!");
        }
        Record oldRecord = null;
        Record record2 = this._recordMap;
        synchronized (record2) {
            try {
                this.load(record.getId());
                oldRecord = this._recordMap.get(record.getId());
            }
            catch (Exception e) {
                this._log.warn((Object)("Error synchronizing record " + record.getId() + " with record storage, creating a new record"), (Throwable)e);
            }
        }
        if (oldRecord == null) {
            this.setRecord(record);
            return;
        }
        record2 = oldRecord;
        synchronized (record2) {
            AnyMap metadata = record.getMetadata();
            if (!metadata.isEmpty()) {
                this.copyAttributes(metadata, oldRecord.getMetadata());
            }
            Iterator attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = (String)attachmentNames.next();
                oldRecord.setAttachment(attachmentName, record.getAttachment(attachmentName));
            }
        }
        this.setRecord(oldRecord);
    }

    @Override
    public void commit() throws BlackboardAccessException {
        int numberOfRecords = this._recordMap.size();
        int commitFailures = 0;
        for (String id : this.getIds()) {
            try {
                this.commit(id);
            }
            catch (Exception ex) {
                ++commitFailures;
                this._log.error((Object)("failed to commit " + id), (Throwable)ex);
            }
        }
        this.invalidate();
        if (commitFailures > 0) {
            throw new BlackboardAccessException("Failed to commit " + commitFailures + " of " + numberOfRecords + " records on blackboard, see log for IDs.");
        }
    }

    @Override
    public void invalidate() {
        for (String string : this.getIds()) {
            try {
                this.invalidate(string);
            }
            catch (Exception ex) {
                this._log.error((Object)("failed to invalidate " + string), (Throwable)ex);
            }
        }
        for (Map map : this._attachmentMap.values()) {
            for (File attachmentFile : map.values()) {
                FileUtils.deleteQuietly((File)attachmentFile);
            }
        }
        this._recordMap.clear();
        this._globalNotes.clear();
        this._recordNotesMap.clear();
        this._attachmentMap.clear();
    }

    @Override
    public Record create(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Record Id cannot be null");
        }
        Record record = this._recordMap.get(id);
        if (record == null) {
            record = this._dataFactory.createRecord(id);
            this._recordMap.put(id, record);
        }
        return record;
    }

    @Override
    public Record load(String id) throws BlackboardAccessException {
        return this.create(id);
    }

    @Override
    public void commit(String id) throws BlackboardAccessException {
        this.invalidate(id);
    }

    @Override
    public void invalidate(String id) {
        Map<String, File> recordFileAttachments = this._attachmentMap.get(id);
        if (recordFileAttachments != null) {
            Set<String> attachmentNames = recordFileAttachments.keySet();
            for (String attachmentName : attachmentNames) {
                File attachment = recordFileAttachments.get(attachmentName);
                FileUtils.deleteQuietly((File)attachment);
            }
        }
        this._recordNotesMap.remove(id);
        this._attachmentMap.remove(id);
        this._recordMap.remove(id);
    }

    @Override
    public void removeRecord(String id) {
        this.invalidate(id);
    }

    @Override
    public boolean hasAttachment(String id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        return record.hasAttachment(name);
    }

    @Override
    public byte[] getAttachment(String id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        if (!record.hasAttachment(name)) {
            throw new BlackboardAccessException("Record with id = " + id + " doesn't have the attachment [" + name + "]");
        }
        return record.getAttachment(name);
    }

    @Override
    public InputStream getAttachmentAsStream(String id, String name) throws BlackboardAccessException {
        return new ByteArrayInputStream(this.getAttachment(id, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getAttachmentAsFile(String id, String name) throws BlackboardAccessException {
        Map<String, Map<String, File>> map = this._attachmentMap;
        synchronized (map) {
            File attachmentFile = null;
            if (this._attachmentMap.get(id) != null && (attachmentFile = this._attachmentMap.get(id).get(name)) != null) {
                return attachmentFile;
            }
            try {
                attachmentFile = new File(this._attachmentsTempDir, this.getAttachmentId(id, name));
                FileUtils.writeByteArrayToFile((File)attachmentFile, (byte[])this.getAttachment(id, name));
                Map<String, File> recordAtttachmentFiles = this._attachmentMap.get(id);
                if (recordAtttachmentFiles == null) {
                    recordAtttachmentFiles = new HashMap<String, File>();
                }
                recordAtttachmentFiles.put(name, attachmentFile);
                this._attachmentMap.put(id, recordAtttachmentFiles);
            }
            catch (IOException ex) {
                throw new BlackboardAccessException("Error getting attachment as file, record id: " + id, ex);
            }
            return attachmentFile;
        }
    }

    @Override
    public void setAttachment(String id, String name, byte[] attachment) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        this.checkCachedFileAttachment(id, name);
        record.setAttachment(name, attachment);
    }

    @Override
    public void setAttachmentFromStream(String id, String name, InputStream attachmentStream) throws BlackboardAccessException {
        try {
            Record record = this.getRecord(id);
            this.checkCachedFileAttachment(id, name);
            record.setAttachment(name, IOUtils.toByteArray((InputStream)attachmentStream));
        }
        catch (IOException ex) {
            throw new BlackboardAccessException(ex);
        }
    }

    @Override
    public void setAttachmentFromFile(String id, String name, File attachmentFile) throws BlackboardAccessException {
        try {
            Record record = this.getRecord(id);
            this.checkCachedFileAttachment(id, name);
            record.setAttachment(name, FileUtils.readFileToByteArray((File)attachmentFile));
        }
        catch (IOException ex) {
            throw new BlackboardAccessException(ex);
        }
    }

    @Override
    public void removeAttachment(String id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id);
        this.checkCachedFileAttachment(id, name);
        record.removeAttachment(name);
    }

    @Override
    public boolean hasGlobalNote(String name) throws BlackboardAccessException {
        return this._globalNotes.containsKey(name);
    }

    @Override
    public Serializable getGlobalNote(String name) throws BlackboardAccessException {
        return this._globalNotes.get(name);
    }

    @Override
    public void setGlobalNote(String name, Serializable object) throws BlackboardAccessException {
        this._globalNotes.put(name, object);
    }

    @Override
    public boolean hasRecordNote(String id, String name) throws BlackboardAccessException {
        Map<String, Serializable> recordNotes = this._recordNotesMap.get(id);
        if (recordNotes == null) {
            return false;
        }
        return recordNotes.containsKey(name);
    }

    @Override
    public Serializable getRecordNote(String id, String name) throws BlackboardAccessException {
        Map<String, Serializable> recordNotes = this._recordNotesMap.get(id);
        if (recordNotes != null) {
            return recordNotes.get(name);
        }
        throw new BlackboardAccessException("Record note not found");
    }

    @Override
    public void setRecordNote(String id, String name, Serializable object) throws BlackboardAccessException {
        Map<String, Serializable> recordNotes = this._recordNotesMap.get(id);
        if (recordNotes == null) {
            recordNotes = new HashMap<String, Serializable>();
            recordNotes.put(name, object);
            this._recordNotesMap.put(id, recordNotes);
        } else {
            recordNotes.put(name, object);
            this._recordNotesMap.put(id, recordNotes);
        }
    }

    protected String getAttachmentId(String id, String name) {
        return DigestHelper.calculateDigest((String)(String.valueOf(id) + "_ATTACHMENT_" + name));
    }

    protected void checkCachedFileAttachment(String id, String name) throws BlackboardAccessException {
        Map<String, File> recordFileAttachments = this._attachmentMap.get(id);
        if (recordFileAttachments != null && recordFileAttachments.get(name) != null) {
            throw new BlackboardAccessException("Attachment [" + name + "] of record with id=" + id + " was previously loaded by getAttachmentAsFile method");
        }
    }

    protected Record getCachedRecord(String id) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Getting cached record with id=" + id));
        }
        return this._recordMap.get(id);
    }

    protected boolean containsRecord(String id) {
        return this._recordMap.containsKey(id);
    }

    protected Collection<String> getIds() {
        return new ArrayList<String>(this._recordMap.keySet());
    }

    protected void copyAttributes(AnyMap source, AnyMap destination) {
        for (String name : source.keySet()) {
            if ("_recordid".equals(name)) continue;
            Any sourceAttribute = (Any)source.get((Object)name);
            Any attribute = this._dataFactory.cloneAny(sourceAttribute);
            destination.put((Object)name, (Object)attribute);
        }
    }
}

