/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.datadictionary;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DAnyFinderDataDictionary;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DAnyFinderDataDictionaryCodec;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DDException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndexCodec;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DConfiguration;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DDateField;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DField;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfig;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DNumberField;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DTextField;
import org.eclipse.smila.search.utils.indexstructure.DIndexField;
import org.eclipse.smila.search.utils.indexstructure.DIndexStructure;
import org.eclipse.smila.search.utils.indexstructure.IndexStructureAccess;
import org.eclipse.smila.search.utils.search.ITFParameter;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.eclipse.smila.utils.xml.XMLUtilsConfig;
import org.eclipse.smila.utils.xml.XMLUtilsException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DataDictionaryController {
    private static final String BUNDLE = "org.eclipse.smila.search.datadictionary";
    private static final String CONFIG_NAME = "DataDictionary.xml";
    private static DAnyFinderDataDictionary _dataDictionaryTypes;
    private static DAnyFinderDataDictionary dd;
    private static Object mutex;

    static {
        mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIndex(DIndex dIndex) throws DataDictionaryException {
        Log log = LogFactory.getLog(DataDictionaryController.class);
        Object object = mutex;
        synchronized (object) {
            DataDictionaryController.ensureLoaded();
            if (DataDictionaryController.hasIndexIgnoreCase(dIndex.getName())) {
                throw new DataDictionaryException("index already exists in data dictionary [" + DataDictionaryController.getExistingIndexName(dIndex.getName()) + "]");
            }
            DConfiguration dConfig = dIndex.getConfiguration();
            if (dConfig != null) {
                DataDictionaryController.validateConfiguration(dConfig, dIndex.getIndexStructure());
            }
            dd.addIndex(dIndex);
            try {
                Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)true, (String)"UTF-8", (OutputStream)new ByteArrayOutputStream());
            }
            catch (DDException e) {
                log.error((Object)"unable to save data dictionary", (Throwable)e);
                try {
                    Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                    log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
                }
                catch (Throwable throwable) {}
                throw new DataDictionaryException("invalid data dictionary");
            }
            catch (XMLUtilsException e) {
                log.error((Object)"Unable to stream DataDictionary!", (Throwable)e);
                try {
                    Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                    log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
                }
                catch (Throwable throwable) {}
                throw new DataDictionaryException("invalid data dictionary while streaming");
            }
            DataDictionaryController.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIndex(String indexTypeName) throws DataDictionaryException {
        DAnyFinderDataDictionary dAnyFinderDataDictionary = dd;
        synchronized (dAnyFinderDataDictionary) {
            DataDictionaryController.ensureLoaded();
            Enumeration<DIndex> indiceTypes = _dataDictionaryTypes.getIndices();
            while (indiceTypes.hasMoreElements()) {
                DAnyFinderDataDictionary dictionary;
                Document doc2;
                DIndex dIndexType = indiceTypes.nextElement();
                if (!dIndexType.getName().equalsIgnoreCase(indexTypeName)) continue;
                Document doc = XMLUtils.getDocument();
                Element rootElement = doc.createElementNS("http://www.anyfinder.de/DataDictionary", "AnyFinderDataDictionary");
                Attr attr = null;
                attr = doc.createAttribute("xmlns:xsi");
                attr.setValue("http://www.w3.org/2001/XMLSchema-instance");
                rootElement.setAttributeNode(attr);
                attr = doc.createAttribute("xsi:schemaLocation");
                attr.setValue("http://www.anyfinder.de/DataDictionary ../xml/AnyFinderDataDictionary.xsd");
                rootElement.setAttributeNode(attr);
                doc.appendChild(rootElement);
                try {
                    DIndexCodec.encode(dIndexType, rootElement);
                }
                catch (DDException e) {
                    throw new DataDictionaryException(e);
                }
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)true, (String)"UTF-8", (OutputStream)bos);
                    doc2 = XMLUtils.parse((byte[])bos.toByteArray(), (boolean)true);
                }
                catch (XMLUtilsException e) {
                    throw new DataDictionaryException(e);
                }
                try {
                    dictionary = DAnyFinderDataDictionaryCodec.decode(doc2.getDocumentElement());
                }
                catch (DDException e) {
                    throw new DataDictionaryException(e);
                }
                DIndex dIndex = dictionary.getIndex(dIndexType.getName());
                DataDictionaryController.addIndex(dIndex);
                return;
            }
        }
        throw new DataDictionaryException(String.format("Index type [%s] was not found!", indexTypeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameIndex(String indexName, String newIndexName) throws DataDictionaryException {
        Log log = LogFactory.getLog(DataDictionaryController.class);
        Object object = mutex;
        synchronized (object) {
            DIndex index;
            block13: {
                DataDictionaryController.ensureLoaded();
                if (dd.getIndex(newIndexName) != null) {
                    throw new DataDictionaryException(String.format("Cannot rename index to [%s] because it's already exists!", newIndexName));
                }
                log.debug((Object)"Updating datadictionary...");
                index = dd.getIndex(indexName);
                if (index != null) break block13;
                return false;
            }
            dd.removeIndex(index);
            index.setName(newIndexName);
            DIndexStructure indexStructure = index.getIndexStructure();
            if (indexStructure != null) {
                indexStructure.setName(newIndexName);
            }
            dd.addIndex(index);
            try {
                Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)true, (String)"UTF-8", (OutputStream)new ByteArrayOutputStream());
            }
            catch (DDException e) {
                log.error((Object)"unable to save data dictionary", (Throwable)e);
                try {
                    Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                    log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
                }
                catch (Throwable throwable) {}
                throw new DataDictionaryException("invalid data dictionary");
            }
            catch (XMLUtilsException e) {
                log.error((Object)"Unable to stream DataDictionary!", (Throwable)e);
                try {
                    Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                    log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
                }
                catch (Throwable throwable) {}
                throw new DataDictionaryException("invalid data dictionary while streaming");
            }
            DataDictionaryController.save();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteIndex(String indexName) throws DataDictionaryException {
        Log log = LogFactory.getLog(DataDictionaryController.class);
        Object object = mutex;
        synchronized (object) {
            DIndex index;
            block11: {
                DataDictionaryController.ensureLoaded();
                log.debug((Object)"Updating datadictionary...");
                index = dd.getIndex(indexName);
                if (index != null) break block11;
                return false;
            }
            dd.removeIndex(index);
            try {
                Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)true, (String)"UTF-8", (OutputStream)new ByteArrayOutputStream());
            }
            catch (DDException e) {
                log.error((Object)"unable to save data dictionary", (Throwable)e);
                try {
                    Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                    log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
                }
                catch (Throwable throwable) {}
                throw new DataDictionaryException("invalid data dictionary");
            }
            catch (XMLUtilsException e) {
                log.error((Object)"Unable to stream DataDictionary!", (Throwable)e);
                try {
                    Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                    log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
                }
                catch (Throwable throwable) {}
                throw new DataDictionaryException("invalid data dictionary while streaming");
            }
            DataDictionaryController.save();
            return true;
        }
    }

    public static DAnyFinderDataDictionary getDataDictionaryTypes() throws DataDictionaryException {
        DataDictionaryController.ensureLoaded();
        return _dataDictionaryTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded() throws DataDictionaryException {
        if (dd == null) {
            Object object = mutex;
            synchronized (object) {
                if (dd == null) {
                    DataDictionaryController.loadDataDictionary();
                }
            }
        }
    }

    public static DAnyFinderDataDictionary getDataDictionary() throws DataDictionaryException {
        DataDictionaryController.ensureLoaded();
        return dd;
    }

    public static String getExistingIndexName(String indexName) throws DataDictionaryException {
        DataDictionaryController.ensureLoaded();
        Enumeration<DIndex> e = dd.getIndices();
        while (e.hasMoreElements()) {
            String name = e.nextElement().getName();
            if (!name.equalsIgnoreCase(indexName)) continue;
            return name;
        }
        return null;
    }

    public static DIndex getIndex(String indexName) throws DataDictionaryException {
        DataDictionaryController.ensureLoaded();
        DIndex dIndex = dd.getIndex(indexName);
        if (dIndex == null) {
            throw new DataDictionaryException("index does not exist in data dictionary [" + indexName + "]");
        }
        return dIndex;
    }

    public static boolean hasIndex(String indexName) throws DataDictionaryException {
        DataDictionaryController.ensureLoaded();
        return dd.getIndex(indexName) != null;
    }

    public static boolean hasIndexIgnoreCase(String indexName) throws DataDictionaryException {
        DataDictionaryController.ensureLoaded();
        Enumeration<DIndex> e = dd.getIndices();
        while (e.hasMoreElements()) {
            String name = e.nextElement().getName();
            if (!name.equalsIgnoreCase(indexName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDataDictionary() throws DataDictionaryException {
        Object object = mutex;
        synchronized (object) {
            File workspace;
            Log log = LogFactory.getLog(DataDictionaryController.class);
            InputStream is = ConfigUtils.getConfigStream((String)BUNDLE, (String)CONFIG_NAME);
            _dataDictionaryTypes = DataDictionaryController.parseDataDictionary(is, log);
            try {
                workspace = WorkspaceHelper.createWorkingDir((String)BUNDLE);
            }
            catch (IOException e) {
                throw new DataDictionaryException(e);
            }
            File ddFile = new File(workspace, CONFIG_NAME);
            if (!ddFile.exists()) {
                dd = new DAnyFinderDataDictionary();
            } else {
                try {
                    is = new FileInputStream(ddFile);
                }
                catch (FileNotFoundException e) {
                    throw new DataDictionaryException(e);
                }
                dd = DataDictionaryController.parseDataDictionary(is, log);
            }
        }
    }

    private static DAnyFinderDataDictionary parseDataDictionary(InputStream is, Log log) throws DataDictionaryException {
        try {
            Document doc = XMLUtils.parse((InputStream)is, (XMLUtilsConfig)new XMLUtilsConfig());
            DAnyFinderDataDictionary dAnyFinderDataDictionary = DAnyFinderDataDictionaryCodec.decode(doc.getDocumentElement());
            return dAnyFinderDataDictionary;
        }
        catch (XMLUtilsException e) {
            log.error((Object)"Unable parse DataDictionary!", (Throwable)e);
            throw new DataDictionaryException("Unable parse DataDictionary!");
        }
        catch (DDException e) {
            log.error((Object)"unable to load data dictionary", (Throwable)e);
            throw new DataDictionaryException("Unable to decode XML into DataDictionary");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private static void save() throws DataDictionaryException {
        File workspaceFolder;
        Log log = LogFactory.getLog(DataDictionaryController.class);
        try {
            workspaceFolder = WorkspaceHelper.createWorkingDir((String)BUNDLE);
        }
        catch (IOException e) {
            throw new DataDictionaryException(e);
        }
        try {
            Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
            XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)true, (String)"UTF-8", (File)new File(workspaceFolder, CONFIG_NAME));
        }
        catch (DDException e) {
            log.error((Object)"unable to save data dictionary", (Throwable)e);
            try {
                Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
            }
            catch (Throwable throwable) {}
            throw new DataDictionaryException("unable to update data dictionary");
        }
        catch (XMLUtilsException e) {
            log.error((Object)"Unable to stream DataDictionary!", (Throwable)e);
            try {
                Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
            }
            catch (Throwable throwable) {}
            throw new DataDictionaryException("Unable to stream DataDictionary!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIndexConfiguration(String indexName, DConfiguration dConfiguration) throws DataDictionaryException {
        Log log = LogFactory.getLog(DataDictionaryController.class);
        Object object = mutex;
        synchronized (object) {
            DataDictionaryController.ensureLoaded();
            if (!DataDictionaryController.hasIndex(indexName)) {
                throw new DataDictionaryException("index does not exist in data dictionary [" + indexName + "]");
            }
            DIndex dIndex = dd.getIndex(indexName);
            DIndexStructure dIS = dIndex.getIndexStructure();
            DataDictionaryController.validateConfiguration(dConfiguration, dIS);
            dIndex.setConfiguration(dConfiguration);
            try {
                Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)true, (String)"UTF-8", (OutputStream)new ByteArrayOutputStream());
            }
            catch (DDException e) {
                log.error((Object)"unable to save data dictionary", (Throwable)e);
                try {
                    Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                    log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
                }
                catch (Throwable throwable) {}
                throw new DataDictionaryException("invalid data dictionary");
            }
            catch (XMLUtilsException e) {
                log.error((Object)"Unable to stream DataDictionary!", (Throwable)e);
                try {
                    Document doc = DAnyFinderDataDictionaryCodec.encode(dd);
                    log.debug((Object)("invalid data dictionary\n" + new String(XMLUtils.stream((Element)doc.getDocumentElement(), (boolean)false))));
                }
                catch (Throwable throwable) {}
                throw new DataDictionaryException("invalid data dictionary while streaming");
            }
            DataDictionaryController.save();
        }
    }

    public static void validateConfiguration(DConfiguration dConfiguration, DIndexStructure dIS) throws DataDictionaryException {
        if (dConfiguration == null) {
            throw new DataDictionaryException("No default configuration defined for index");
        }
        if (dConfiguration.getDefaultConfig().getFieldCount() != dIS.getFieldCount()) {
            throw new DataDictionaryException("Invalid default configuration. Field counts in DefaultConfig and IndexStructure do not match: [" + dConfiguration.getDefaultConfig().getFieldCount() + "/" + dIS.getFieldCount() + "]");
        }
        IndexStructureAccess indexStructureAccess = IndexStructureAccess.getInstance();
        int i = 0;
        while (i < dIS.getFieldCount()) {
            DField field = dConfiguration.getDefaultConfig().getField(i);
            if (field == null) {
                throw new DataDictionaryException("Default configuration missing for field " + i);
            }
            DFieldConfig configField = field.getFieldConfig();
            DIndexField dIF = dIS.getField(field.getFieldNo());
            if (dIF != null && !indexStructureAccess.dataTypeMatches(dIF.getType(), configField.getType())) {
                throw new DataDictionaryException("Type of field '" + field.getFieldNo() + "' in DefaultConfig does not match type of index field");
            }
            if (configField.getConstraint() == null) {
                throw new DataDictionaryException("'Constraint' parameter missing in DefaultConfig for field [" + i + "]");
            }
            if (configField.getWeight() == null) {
                throw new DataDictionaryException("'Weight' parameter missing in DefaultConfig for field [" + i + "]");
            }
            ITFParameter param = null;
            if (configField instanceof DTextField) {
                param = ((DTextField)configField).getParameter();
            }
            if (configField instanceof DNumberField) {
                param = ((DNumberField)configField).getParameter();
            }
            if (configField instanceof DDateField) {
                param = ((DDateField)configField).getParameter();
            }
            if (param == null) {
                throw new DataDictionaryException("'Parameter' parameter missing in DefaultConfig for field [" + i + "]");
            }
            if (!param.isComplete()) {
                throw new DataDictionaryException("'Parameter' parameter is incomplete in DefaultConfig for field [" + i + "]");
            }
            ++i;
        }
    }
}

