/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.common.extension;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.extension.ExtensionBundleValidation;
import org.apache.ode.bpel.extension.ExtensionOperation;
import org.apache.ode.bpel.extension.ExtensionValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtensionBundle
implements ExtensionBundleRuntime,
ExtensionBundleValidation {
    private static Log __log = LogFactory.getLog(AbstractExtensionBundle.class);
    private Map<String, Class<? extends ExtensionOperation>> extensionsByName = new HashMap<String, Class<? extends ExtensionOperation>>();

    public abstract String getNamespaceURI();

    public abstract void registerExtensionActivities();

    protected final void registerExtensionOperation(String string, Class<? extends ExtensionOperation> clazz) {
        this.extensionsByName.put(string, clazz);
    }

    public final Set<String> getExtensionOperationNames() {
        return Collections.unmodifiableSet(this.extensionsByName.keySet());
    }

    public final Class<? extends ExtensionOperation> getExtensionOperationClass(String string) {
        return this.extensionsByName.get(string);
    }

    public final ExtensionOperation getExtensionOperationInstance(String string) throws InstantiationException, IllegalAccessException {
        return this.getExtensionOperationClass(string).newInstance();
    }

    public final Map<QName, ExtensionValidator> getExtensionValidators() {
        HashMap<QName, ExtensionValidator> hashMap = new HashMap<QName, ExtensionValidator>();
        String string = this.getNamespaceURI();
        for (String string2 : this.extensionsByName.keySet()) {
            if (!ExtensionValidator.class.isAssignableFrom(this.extensionsByName.get(string2))) continue;
            try {
                hashMap.put(new QName(string, string2), (ExtensionValidator)this.getExtensionOperationInstance(string2));
            }
            catch (Exception exception) {
                __log.warn((Object)("Could not instantiate extension validator for '{" + string + "}" + string2));
            }
        }
        return hashMap;
    }
}

