/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.ExpressionLanguageRuntime;
import org.apache.ode.bpel.rtrep.v1.OExpression;
import org.apache.ode.bpel.rtrep.v1.OExpressionLanguage;
import org.apache.ode.utils.xsd.Duration;
import org.w3c.dom.Node;

public class ExpressionLanguageRuntimeRegistry {
    private final Map<OExpressionLanguage, ExpressionLanguageRuntime> _runtimes = new HashMap<OExpressionLanguage, ExpressionLanguageRuntime>();

    public void registerRuntime(OExpressionLanguage oExpressionLanguage) throws ConfigurationException {
        try {
            String string = oExpressionLanguage.properties.get("runtime-class");
            string = string.replace("com.fs.pxe.", "org.apache.ode.");
            Class<?> clazz = Class.forName(string);
            ExpressionLanguageRuntime expressionLanguageRuntime = (ExpressionLanguageRuntime)clazz.newInstance();
            expressionLanguageRuntime.initialize(oExpressionLanguage.properties);
            this._runtimes.put(oExpressionLanguage, expressionLanguageRuntime);
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigurationException("Illegal Access Error", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ConfigurationException("Instantiation Error", instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("Class Not Found Error", classNotFoundException);
        }
    }

    public String evaluateAsString(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return this.findRuntime(oExpression).evaluateAsString(oExpression, evaluationContext);
    }

    public boolean evaluateAsBoolean(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return this.findRuntime(oExpression).evaluateAsBoolean(oExpression, evaluationContext);
    }

    public Number evaluateAsNumber(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return this.findRuntime(oExpression).evaluateAsNumber(oExpression, evaluationContext);
    }

    public List evaluate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return this.findRuntime(oExpression).evaluate(oExpression, evaluationContext);
    }

    public Node evaluateNode(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return this.findRuntime(oExpression).evaluateNode(oExpression, evaluationContext);
    }

    public Calendar evaluateAsDate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return this.findRuntime(oExpression).evaluateAsDate(oExpression, evaluationContext);
    }

    public Duration evaluateAsDuration(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return this.findRuntime(oExpression).evaluateAsDuration(oExpression, evaluationContext);
    }

    private ExpressionLanguageRuntime findRuntime(OExpression oExpression) {
        return this._runtimes.get(oExpression.expressionLanguage);
    }
}

