/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ActivityFailureEvent;
import org.apache.ode.bpel.evt.ActivityRecoveryEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rtrep.v1.ACTIVITY;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OFailureHandling;
import org.apache.ode.bpel.rtrep.v1.OInvoke;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.rtrep.v1.channels.ActivityRecoveryChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.InvokeResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.InvokeResponseChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INVOKE
extends ACTIVITY {
    private static final long serialVersionUID = 992248281026821783L;
    private static final Log __log = LogFactory.getLog(INVOKE.class);
    private OInvoke _oinvoke;
    private int _invoked;
    private Date _lastFailure;
    private String _failureReason;
    private Element _failureData;

    public INVOKE(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
        this._oinvoke = (OInvoke)this._self.o;
        this._invoked = 0;
    }

    public final void run() {
        Element element;
        try {
            element = this.setupOutbound(this._oinvoke, this._oinvoke.initCorrelationsInput);
        }
        catch (FaultException faultException) {
            __log.error((Object)faultException);
            FaultData faultData = this.createFault(faultException.getQName(), this._oinvoke);
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
            return;
        }
        catch (ExternalVariableModuleException externalVariableModuleException) {
            __log.error((Object)externalVariableModuleException);
            this._self.parent.failure(externalVariableModuleException.toString(), null);
            return;
        }
        ++this._invoked;
        boolean bl = this._oinvoke.outputVar != null;
        try {
            if (!bl) {
                FaultData faultData = null;
                this.getBpelRuntime().invoke(null, this._scopeFrame.resolve(this._oinvoke.partnerLink), this._oinvoke.operation, element, null);
                this._self.parent.completed(faultData, CompensationHandler.emptySet());
            } else {
                final VariableInstance variableInstance = this._scopeFrame.resolve(this._oinvoke.outputVar);
                final InvokeResponseChannel invokeResponseChannel = (InvokeResponseChannel)this.newChannel(InvokeResponseChannel.class);
                final String string = this.getBpelRuntime().invoke(invokeResponseChannel.export(), this._scopeFrame.resolve(this._oinvoke.partnerLink), this._oinvoke.operation, element, invokeResponseChannel);
                INVOKE.object((boolean)false, (Set)new InvokeResponseChannelListener(invokeResponseChannel){
                    private static final long serialVerstmptmpionUID = 4496880438819196765L;

                    public void onResponse() {
                        Element element;
                        FaultData faultData = null;
                        try {
                            element = INVOKE.this.getBpelRuntime().getPartnerResponse(string);
                        }
                        catch (Exception exception) {
                            __log.error((Object)"Exception while processing invoke response", (Throwable)exception);
                            throw new RuntimeException(exception);
                        }
                        try {
                            INVOKE.this.initializeVariable(variableInstance, element);
                        }
                        catch (ExternalVariableModuleException externalVariableModuleException) {
                            __log.error((Object)"Exception while initializing external variable", (Throwable)externalVariableModuleException);
                            INVOKE.this._self.parent.failure(externalVariableModuleException.toString(), null);
                            return;
                        }
                        VariableModificationEvent variableModificationEvent = new VariableModificationEvent(variableInstance.declaration.name);
                        variableModificationEvent.setNewValue((Node)element);
                        if (((INVOKE)INVOKE.this)._oinvoke.debugInfo != null) {
                            variableModificationEvent.setLineNo(((INVOKE)INVOKE.this)._oinvoke.debugInfo.startLine);
                        }
                        INVOKE.this.sendEvent((ScopeEvent)variableModificationEvent);
                        try {
                            Object object = ((INVOKE)INVOKE.this)._oinvoke.initCorrelationsOutput.iterator();
                            while (object.hasNext()) {
                                OScope.CorrelationSet correlationSet = object.next();
                                INVOKE.this.initializeCorrelation(INVOKE.this._scopeFrame.resolve(correlationSet), variableInstance);
                            }
                            if (((INVOKE)INVOKE.this)._oinvoke.partnerLink.hasPartnerRole()) {
                                if (!(INVOKE.this.getBpelRuntime().isPartnerRoleEndpointInitialized(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink)) && ((INVOKE)INVOKE.this)._oinvoke.partnerLink.initializePartnerRole || (object = INVOKE.this.getBpelRuntime().getSourceEPR(string)) == null)) {
                                    INVOKE.this.getBpelRuntime().writeEndpointReference(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink), (Element)object);
                                }
                                if ((object = INVOKE.this.getBpelRuntime().getSourceSessionId(string)) != null) {
                                    INVOKE.this.getBpelRuntime().initializePartnersSessionId(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink), (String)object);
                                }
                            }
                        }
                        catch (FaultException faultException) {
                            faultData = INVOKE.this.createFault(faultException.getQName(), INVOKE.this._oinvoke);
                        }
                        INVOKE.this._self.parent.completed(faultData, CompensationHandler.emptySet());
                        INVOKE.this.getBpelRuntime().releasePartnerMex(string);
                    }

                    public void onFault() {
                        QName qName = INVOKE.this.getBpelRuntime().getPartnerFault(string);
                        Element element = INVOKE.this.getBpelRuntime().getPartnerResponse(string);
                        QName qName2 = INVOKE.this.getBpelRuntime().getPartnerResponseType(string);
                        FaultData faultData = INVOKE.this.createFault(qName, element, ((INVOKE)INVOKE.this)._oinvoke.getOwner().messageTypes.get(qName2), INVOKE.this._self.o);
                        INVOKE.this._self.parent.completed(faultData, CompensationHandler.emptySet());
                        INVOKE.this.getBpelRuntime().releasePartnerMex(string);
                    }

                    public void onFailure() {
                        String string2 = INVOKE.this.getBpelRuntime().getPartnerFaultExplanation(string);
                        __log.error((Object)("Failure during invoke: " + string2));
                        try {
                            Element element = DOMUtils.stringToDOM((String)("<invokeFailure><![CDATA[" + string2 + "]]></invokeFailure>"));
                            INVOKE.this._self.parent.failure(string2, element);
                        }
                        catch (Exception exception) {
                            INVOKE.this._self.parent.failure(string2, null);
                        }
                        INVOKE.this.getBpelRuntime().releasePartnerMex(string);
                    }
                }.or(new TerminationChannelListener(this._self.self){
                    private static final long serialVersionUID = 4219496341785922396L;

                    public void terminate() {
                        INVOKE.this._self.parent.completed(null, CompensationHandler.emptySet());
                        1.object((ChannelListener)new InvokeResponseChannelListener(invokeResponseChannel){
                            private static final long serialVersionUID = 688746737897792929L;

                            public void onFailure() {
                                __log.debug((Object)("Failure on invoke ignored, the invoke has already been terminated: " + INVOKE.this._oinvoke.toString()));
                            }

                            public void onFault() {
                                __log.debug((Object)("Fault on invoke ignored, the invoke has already been terminated: " + INVOKE.this._oinvoke.toString()));
                            }

                            public void onResponse() {
                                __log.debug((Object)("Response on invoke ignored, the invoke has already been terminated: " + INVOKE.this._oinvoke.toString()));
                            }
                        });
                    }
                }));
            }
        }
        catch (FaultException faultException) {
            __log.error((Object)faultException);
            FaultData faultData = this.createFault(faultException.getQName(), this._oinvoke, faultException.getMessage());
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
        }
    }

    private Element setupOutbound(OInvoke oInvoke, Collection<OScope.CorrelationSet> collection) throws FaultException, ExternalVariableModuleException {
        if (collection.size() > 0) {
            for (OScope.CorrelationSet correlationSet : collection) {
                this.initializeCorrelation(this._scopeFrame.resolve(correlationSet), this._scopeFrame.resolve(oInvoke.inputVar));
            }
        }
        if (oInvoke.operation.getInput().getMessage().getParts().size() > 0) {
            this.sendVariableReadEvent(this._scopeFrame.resolve(oInvoke.inputVar));
            Node node = this.fetchVariableData(this._scopeFrame.resolve(oInvoke.inputVar), false);
            assert (node instanceof Element);
            return (Element)node;
        }
        return null;
    }

    private void requireRecovery() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("ActivityRecovery: Invoke activity " + this._self.aId + " requires recovery"));
        }
        this.sendEvent((ActivityEvent)new ActivityFailureEvent(this._failureReason));
        final ActivityRecoveryChannel activityRecoveryChannel = (ActivityRecoveryChannel)this.newChannel(ActivityRecoveryChannel.class);
        this.getBpelRuntime().registerActivityForRecovery(activityRecoveryChannel, this._self.aId, this._failureReason, this._lastFailure, this._failureData, new String[]{"retry", "cancel", "fault"}, this._invoked - 1);
        INVOKE.object((boolean)false, (Set)new ActivityRecoveryChannelListener(activityRecoveryChannel){
            private static final long serialVersionUID = 8397883882810521685L;

            public void retry() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Retrying invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("retry"));
                INVOKE.this.getBpelRuntime().unregisterActivityForRecovery(activityRecoveryChannel);
                4.instance((JacobRunnable)INVOKE.this);
            }

            public void cancel() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Cancelling invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("cancel"));
                INVOKE.this.getBpelRuntime().unregisterActivityForRecovery(activityRecoveryChannel);
                INVOKE.this._self.parent.cancelled();
            }

            public void fault(FaultData faultData) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Faulting invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("fault"));
                INVOKE.this.getBpelRuntime().unregisterActivityForRecovery(activityRecoveryChannel);
                if (faultData == null) {
                    faultData = INVOKE.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, INVOKE.this._self.o, INVOKE.this._failureReason);
                }
                INVOKE.this._self.parent.completed(faultData, CompensationHandler.emptySet());
            }
        }.or(new TerminationChannelListener(this._self.self){
            private static final long serialVersionUID = 2148587381204858397L;

            public void terminate() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Cancelling invoke activity " + INVOKE.this._self.aId + " (terminated by scope)"));
                }
                INVOKE.this.getBpelRuntime().unregisterActivityForRecovery(activityRecoveryChannel);
                INVOKE.this._self.parent.completed(null, CompensationHandler.emptySet());
            }
        }));
    }
}

