/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xml.capture;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ode.utils.XMLParserUtils;
import org.apache.ode.utils.xml.capture.MultiplexTracker;
import org.apache.ode.utils.xml.capture.Tracker;
import org.apache.ode.utils.xml.capture.Wsdl11Tracker;
import org.apache.ode.utils.xml.capture.XmlSchemaTracker;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDependencyScanner {
    private Map<URI, Exception> _errors = new HashMap<URI, Exception>();
    private Map<URI, Set<URI>> _references = new HashMap<URI, Set<URI>>();
    private Map<URI, Set<URI>> _referers = new HashMap<URI, Set<URI>>();
    private EntityResolver _resolver;
    private MultiplexTracker _mch;

    public XmlDependencyScanner() {
        HashSet<Tracker> hashSet = new HashSet<Tracker>();
        hashSet.add(new Wsdl11Tracker());
        hashSet.add(new XmlSchemaTracker());
        this._mch = new MultiplexTracker(hashSet);
    }

    public void setResolver(EntityResolver entityResolver) {
        this._resolver = entityResolver;
    }

    public EntityResolver getResolver() {
        return this._resolver;
    }

    public void process(URI uRI) {
        if (this._references.keySet().contains(uRI)) {
            return;
        }
        HashSet<URI> hashSet = new HashSet<URI>();
        hashSet.add(uRI);
        while (!hashSet.isEmpty()) {
            Object object;
            Iterator iterator = hashSet.iterator();
            URI uRI2 = (URI)iterator.next();
            iterator.remove();
            HashSet<URI> hashSet2 = new HashSet<URI>();
            this._mch.init(uRI2, hashSet2);
            try {
                object = XMLParserUtils.getXMLReader();
                object.setContentHandler(this._mch);
                object.setFeature("http://xml.org/sax/features/namespaces", true);
                object.setEntityResolver(this._resolver);
                object.parse(uRI2.toASCIIString());
                this._references.put(uRI2, new HashSet<URI>(hashSet2));
            }
            catch (Exception exception) {
                this._errors.put(uRI2, exception);
            }
            object = hashSet2.iterator();
            while (object.hasNext()) {
                this.addReferer((URI)object.next(), uRI2);
            }
            hashSet2.removeAll(this._references.keySet());
            hashSet.addAll(hashSet2);
        }
    }

    public Set<URI> getURIs() {
        return this._references.keySet();
    }

    public Set<URI> getReferences(URI uRI) {
        Set<URI> set = this._references.get(uRI);
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public boolean isError() {
        return !this._errors.isEmpty();
    }

    public Set<URI> getReferers(URI uRI) {
        Set<URI> set = this._referers.get(uRI);
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    void addReferer(URI uRI, URI uRI2) {
        Set<URI> set = this._referers.get(uRI);
        if (set == null) {
            set = new HashSet<URI>();
            this._referers.put(uRI, set);
        }
        set.add(uRI2);
    }

    public Map<URI, Exception> getErrors() {
        return this._errors;
    }
}

