/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.lucene.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.lucene.LuceneIndexService;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.utils.service.ServiceUtils;

public class LuceneIndexPipelet
implements Pipelet {
    public static final String INDEXING_PARAMETERS = "_indexing";
    public static final String INDEX_NAME = "indexname";
    public static final String EXECUTION_MODE = "executionMode";
    public static final String ALLOW_DOUBLETS = "allowDoublets";
    private final Log _log = LogFactory.getLog(LuceneIndexPipelet.class);
    private LuceneIndexService _service;
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        block12: {
            try {
                LuceneIndexService service = this.getLuceneIndexService();
                ParameterAccessor parameters = new ParameterAccessor(blackboard, this._configuration);
                String[] stringArray = recordIds;
                int n = recordIds.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        String recordId = stringArray[n2];
                        try {
                            parameters.setCurrentRecord(recordId);
                            AnyMap indexParams = parameters.getSubParameter(INDEXING_PARAMETERS);
                            String executionModeValue = indexParams.getStringValue(EXECUTION_MODE);
                            String indexName = indexParams.getStringValue(INDEX_NAME);
                            boolean allowDoublets = Boolean.valueOf(indexParams.getStringValue(ALLOW_DOUBLETS));
                            if (executionModeValue == null) {
                                throw new ProcessingException("Missing executionMode parameter for record " + recordId);
                            }
                            if (indexName == null) {
                                throw new ProcessingException("Missing index parameter for record " + recordId);
                            }
                            LuceneIndexService.ExecutionMode executionMode = LuceneIndexService.ExecutionMode.valueOf(executionModeValue);
                            switch (executionMode) {
                                case ADD: {
                                    service.addRecord(blackboard, recordId, indexName, allowDoublets);
                                    break;
                                }
                                case DELETE: {
                                    service.deleteRecord(recordId, indexName);
                                    break;
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (!this._log.isErrorEnabled()) break block11;
                            this._log.error((Object)("error processing record " + recordId), (Throwable)ex);
                        }
                    }
                    ++n2;
                }
            }
            catch (InterruptedException ie) {
                if (!this._log.isErrorEnabled()) break block12;
                this._log.error((Object)"error getting lucene index service", (Throwable)ie);
            }
        }
        return recordIds;
    }

    private synchronized LuceneIndexService getLuceneIndexService() throws InterruptedException {
        if (this._service == null) {
            this._service = (LuceneIndexService)ServiceUtils.getService(LuceneIndexService.class);
        }
        return this._service;
    }
}

