/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.templates.transformer;

import java.util.StringTokenizer;
import org.eclipse.smila.search.lucene.messages.advsearch.DOPN;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.advsearch.DTermContent;
import org.eclipse.smila.search.lucene.templates.transformer.SimpleNodeTransformer;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.search.utils.advsearch.ITermContent;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DTextField;

public class CaseInsensitiveNodeTransformer
extends SimpleNodeTransformer {
    @Override
    public ITermContent transformNode(DField dField) throws NodeTransformerException {
        try {
            if (dField instanceof DTextField) {
                DTextField tf = (DTextField)((DTextField)dField).clone();
                DTextFieldParameter tfp = (DTextFieldParameter)tf.getParameter();
                if (tfp.getOperator() != DTextFieldParameter.DOperator.PHRASE) {
                    String fieldText = tf.getText().trim();
                    StringTokenizer st = new StringTokenizer(fieldText, " ");
                    int tokenCount = st.countTokens();
                    if (tokenCount == 1) {
                        return this.convertTerm(tf);
                    }
                    DOPN op = new DOPN();
                    if (tfp.getOperator() == DTextFieldParameter.DOperator.AND) {
                        op.setOperation("AND");
                    } else if (tfp.getOperator() == DTextFieldParameter.DOperator.OR) {
                        op.setOperation("OR");
                    } else {
                        op.setOperation("WMEAN");
                    }
                    int i = 0;
                    while (i < tokenCount) {
                        tf.setText(st.nextToken());
                        op.addTerm(new DTerm(this.convertTerm(tf)));
                        ++i;
                    }
                    return op;
                }
                return super.transformNode(dField);
            }
            return super.transformNode(dField);
        }
        catch (AdvSearchException e) {
            throw new NodeTransformerException("unable to transform node [" + e.getMessage() + "]");
        }
    }

    private DTermContent convertTerm(DTextField tf) throws NodeTransformerException, AdvSearchException {
        String fieldText = tf.getText().trim();
        String[] words = this.convertWord(fieldText);
        if (words.length == 0) {
            return (DTermContent)super.transformNode((DField)tf);
        }
        tf.setText(words[0]);
        if (words.length == 1) {
            return (DTermContent)super.transformNode((DField)tf);
        }
        DOPN op = new DOPN();
        op.setOperation("OR");
        op.addTerm(new DTerm(super.transformNode((DField)tf)));
        int i = 1;
        while (i < words.length) {
            DTextField f = (DTextField)tf.clone();
            f.setText(words[i]);
            op.addTerm(new DTerm(super.transformNode((DField)f)));
            ++i;
        }
        return op;
    }

    private String[] convertWord(String word) {
        if (word == null || word.length() == 0) {
            return new String[0];
        }
        String lowerCase = word.toLowerCase();
        String capitalCase = String.valueOf(String.valueOf(word.charAt(0)).toUpperCase()) + word.substring(1).toLowerCase();
        int arrayCnt = 1;
        if (!word.equals(lowerCase)) {
            ++arrayCnt;
        } else {
            lowerCase = null;
        }
        if (!word.equals(capitalCase)) {
            ++arrayCnt;
        } else {
            capitalCase = null;
        }
        String[] result = new String[arrayCnt];
        int n = --arrayCnt;
        --arrayCnt;
        result[n] = word;
        if (lowerCase != null) {
            result[arrayCnt--] = lowerCase;
        }
        if (capitalCase != null) {
            result[arrayCnt--] = capitalCase;
        }
        return result;
    }
}

