/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.osgi;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import org.eclipse.smila.management.jmx.client.config.JmxClientConfigType;
import org.eclipse.smila.management.jmx.client.exceptions.ConfigurationLoadException;
import org.eclipse.smila.management.jmx.client.helpers.ConfigLoader;
import org.eclipse.smila.utils.jaxb.JaxbUtils;
import org.eclipse.smila.utils.xml.SchemaUtils;

public final class OSGiConfigLoader {
    private OSGiConfigLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JmxClientConfigType load(InputStream is) throws ConfigurationLoadException {
        JmxClientConfigType jmxClientConfigType;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(OSGiConfigLoader.class.getClassLoader());
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.eclipse.smila.management.jmx.client.config");
            Schema schema = SchemaUtils.loadSchemaRuntimeEx((String)"org.eclipse.smila.management.jmx.client", (String)"schemas/jmxclient.xsd");
            Unmarshaller unmarshaller = JaxbUtils.createValidatingUnmarshaller((JAXBContext)context, (Schema)schema);
            unmarshaller.setEventHandler(ConfigLoader.createValidationEventHandler());
            Object result = unmarshaller.unmarshal(is);
            if (result != null && result instanceof JAXBElement) {
                result = ((JAXBElement)result).getValue();
            }
            jmxClientConfigType = (JmxClientConfigType)result;
            Thread.currentThread().setContextClassLoader(tccl);
            if (is == null) return jmxClientConfigType;
        }
        catch (Throwable e) {
            try {
                throw new ConfigurationLoadException("Unable to load configuration", e);
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(tccl);
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
        }
        try {
            is.close();
            return jmxClientConfigType;
        }
        catch (Throwable throwable) {}
        return jmxClientConfigType;
    }
}

