/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.impl;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.datamodel.impl.AnyMapImpl;
import org.eclipse.smila.datamodel.impl.AnySeqImpl;
import org.eclipse.smila.datamodel.impl.RecordImpl;
import org.eclipse.smila.datamodel.impl.ValueImpl;

public class DefaultDataFactoryImpl
implements DataFactory {
    public static final DefaultDataFactoryImpl INSTANCE = new DefaultDataFactoryImpl();

    @Override
    public Record createRecord() {
        return this.createRecord(null, null);
    }

    @Override
    public Record createRecord(String id) {
        return this.createRecord(id, null);
    }

    @Override
    public Record createRecord(String id, String source) {
        RecordImpl record = new RecordImpl();
        record.setId(id);
        record.setSource(source);
        return record;
    }

    @Override
    public AnyMap createAnyMap() {
        return new AnyMapImpl();
    }

    @Override
    public AnySeq createAnySeq() {
        return new AnySeqImpl();
    }

    @Override
    public Value createStringValue(String value) {
        return new ValueImpl(Any.ValueType.STRING, value);
    }

    @Override
    public Value createBooleanValue(Boolean value) {
        return new ValueImpl(Any.ValueType.BOOLEAN, value);
    }

    @Override
    public Value createLongValue(Long value) {
        return new ValueImpl(Any.ValueType.LONG, value);
    }

    @Override
    public Value createLongValue(int value) {
        return new ValueImpl(Any.ValueType.LONG, value);
    }

    @Override
    public Value createDoubleValue(Double value) {
        return new ValueImpl(Any.ValueType.DOUBLE, value);
    }

    @Override
    public Value createDoubleValue(float value) {
        return new ValueImpl(Any.ValueType.DOUBLE, value);
    }

    @Override
    public Value createDateValue(Date value) {
        return new ValueImpl(Any.ValueType.DATE, new Date(value.getTime()));
    }

    @Override
    public Value createDateTimeValue(Date value) {
        return new ValueImpl(Any.ValueType.DATETIME, new Date(value.getTime()));
    }

    @Override
    public Value parseFromString(String value, String type) {
        Any.ValueType valueType = null;
        if (type == null) {
            valueType = Any.ValueType.STRING;
        } else {
            try {
                valueType = Any.ValueType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidValueTypeException("invalid type: " + type);
            }
        }
        try {
            switch (valueType) {
                case BOOLEAN: {
                    return this.createBooleanValue(Boolean.parseBoolean(value));
                }
                case DATE: {
                    return this.createDateValue(ValueFormatHelper.INSTANCE.parseDate(value));
                }
                case DATETIME: {
                    return this.createDateTimeValue(ValueFormatHelper.INSTANCE.parseDateTime(value));
                }
                case DOUBLE: {
                    return this.createDoubleValue(Double.parseDouble(value));
                }
                case LONG: {
                    return this.createLongValue(Long.parseLong(value));
                }
                case STRING: {
                    return this.createStringValue(value);
                }
            }
            throw new NotImplementedException("conversion for type: " + (Object)((Object)valueType));
        }
        catch (Exception e) {
            throw new InvalidValueTypeException(String.format("cannot convert value %s into %s", new Object[]{value, valueType}), e);
        }
    }

    @Override
    public Value parseFromObject(Object object) {
        return this.autoConvertValue(object);
    }

    @Override
    public Value autoConvertValue(Object object) {
        if (object instanceof String) {
            return this.createStringValue((String)object);
        }
        if (object instanceof Double) {
            return this.createDoubleValue((Double)object);
        }
        if (object instanceof Long) {
            return this.createLongValue((Long)object);
        }
        if (object instanceof Integer) {
            return this.createLongValue(((Integer)object).longValue());
        }
        if (object instanceof Short) {
            return this.createLongValue(((Short)object).longValue());
        }
        if (object instanceof Byte) {
            return this.createLongValue(((Byte)object).longValue());
        }
        if (object instanceof Number) {
            return this.createDoubleValue(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return this.createBooleanValue((Boolean)object);
        }
        if (object instanceof Date) {
            return this.createDateTimeValue((Date)object);
        }
        throw new InvalidValueTypeException(object.getClass());
    }

    @Override
    public Any cloneAny(Any source) {
        if (source == null) {
            return null;
        }
        switch (source.getValueType()) {
            case MAP: {
                return this.cloneAnyMap((AnyMap)source);
            }
            case SEQ: {
                return this.cloneAnySeq((AnySeq)source);
            }
        }
        return new ValueImpl((Value)source);
    }

    @Override
    public AnyMap cloneAnyMap(AnyMap source) {
        if (source == null) {
            return null;
        }
        AnyMap destination = this.createAnyMap();
        for (Map.Entry entry : source.entrySet()) {
            destination.put((String)entry.getKey(), this.cloneAny((Any)entry.getValue()));
        }
        return destination;
    }

    @Override
    public AnySeq cloneAnySeq(AnySeq source) {
        if (source == null) {
            return null;
        }
        AnySeq destination = this.createAnySeq();
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            destination.add(this.cloneAny((Any)iterator.next()));
        }
        return destination;
    }
}

